/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.advancements;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;

public class ArmyPopulationTrigger
extends SimpleCriterionTrigger<ArmyPopulationTriggerInstance> {
    public void trigger(ServerPlayer player, int armySize) {
        this.trigger(player, trigger -> trigger.test(armySize));
    }

    public Codec<ArmyPopulationTriggerInstance> codec() {
        return ArmyPopulationTriggerInstance.CODEC;
    }

    public record ArmyPopulationTriggerInstance(Optional<ContextAwarePredicate> player, int populationCount) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<ArmyPopulationTriggerInstance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(ArmyPopulationTriggerInstance::player), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("population_count").forGetter(ArmyPopulationTriggerInstance::populationCount)).apply((Applicative)builder, ArmyPopulationTriggerInstance::new));

        public static Criterion<ArmyPopulationTriggerInstance> armyPopulation(int populationCount) {
            return ((ArmyPopulationTrigger)((Object)AdvancementTriggers.ARMY_POPULATION.get())).createCriterion((CriterionTriggerInstance)new ArmyPopulationTriggerInstance(Optional.empty(), populationCount));
        }

        public boolean test(int populationCount) {
            return this.populationCount <= populationCount;
        }
    }
}

