/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester;

import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.config.Actionable;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import com.almostreliable.merequester.core.Config;
import com.almostreliable.merequester.requester.Request;
import com.almostreliable.merequester.requester.abstraction.RequestHost;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class RequestManager
implements MEStorage,
GenericInternalInventory,
InternalInventory,
INBTSerializable<CompoundTag> {
    @Nullable
    private final RequestHost host;
    private final Request[] requests;
    private final int size;

    public RequestManager(@Nullable RequestHost host) {
        this.host = host;
        this.size = (Integer)Config.COMMON.requests.get();
        this.requests = new Request[this.size];
        for (int i = 0; i < this.requests.length; ++i) {
            this.requests[i] = new Request(host, i);
        }
    }

    public RequestManager() {
        this(null);
    }

    public Request get(int index) {
        return this.requests[index];
    }

    public int size() {
        return this.size;
    }

    @Nullable
    public GenericStack getStack(int index) {
        return this.get(index).toGenericStack();
    }

    @Nullable
    public AEKey getKey(int index) {
        return this.get(index).getKey();
    }

    public long getAmount(int index) {
        return this.get(index).getAmount();
    }

    public long getMaxAmount(AEKey key) {
        return 1L;
    }

    public long getCapacity(AEKeyType keyType) {
        return 1L;
    }

    public boolean canInsert() {
        return true;
    }

    public boolean canExtract() {
        return false;
    }

    public void setStack(int index, @Nullable GenericStack stack) {
        this.get(index).updateKey(stack);
    }

    public boolean isSupportedType(AEKeyType type) {
        return true;
    }

    public boolean isAllowedIn(int slot, AEKey what) {
        return true;
    }

    public long insert(int index, AEKey key, long amount, Actionable mode) {
        if (mode == Actionable.SIMULATE) {
            return amount;
        }
        if (this.host == null || this.host.isClientSide()) {
            this.get(index).setClientKey(key, amount);
        } else {
            this.get(index).updateKey(new GenericStack(key, amount));
        }
        return amount;
    }

    public long extract(int index, AEKey key, long amount, Actionable mode) {
        throw new UnsupportedOperationException();
    }

    public void onChange() {
        if (this.host != null) {
            this.host.saveChanges();
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.size(); ++i) {
            tag.put(String.valueOf(i), (Tag)this.get(i).serializeNBT(registries));
        }
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag tag) {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).deserializeNBT(registries, tag.getCompound(String.valueOf(i)));
        }
    }

    public void fromComponent(List<Request.Component> exportedRequests) {
        for (int i = 0; i < this.size(); ++i) {
            if (i < exportedRequests.size()) {
                this.get(i).fromComponent(exportedRequests.get(i));
                continue;
            }
            this.setItemDirect(i, ItemStack.EMPTY);
        }
    }

    public List<Request.Component> toComponent() {
        ArrayList<Request.Component> result = new ArrayList<Request.Component>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.add(this.get(i).toComponent());
        }
        return result;
    }

    public int firstAvailableIndex() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getKey(i) != null) continue;
            return i;
        }
        return -1;
    }

    public Component getDescription() {
        if (this.host == null) {
            return Component.empty();
        }
        return this.host.getTerminalName();
    }

    public void beginBatch() {
    }

    public void endBatch() {
    }

    public void endBatchSuppressed() {
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.isEmpty() || this.convertToSuitableStack(stack) != null;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        AEKey aEKey;
        GenericStack genericStack = this.getStack(slot);
        if (genericStack != null && (aEKey = genericStack.what()) instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)aEKey;
            return itemKey.toStack();
        }
        return GenericStack.wrapInItemStack((GenericStack)genericStack);
    }

    public void setItemDirect(int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            this.setStack(slot, null);
        } else {
            GenericStack converted = this.convertToSuitableStack(stack);
            if (converted != null) {
                this.setStack(slot, converted);
            }
        }
    }

    @Nullable
    private GenericStack convertToSuitableStack(ItemStack stack) {
        AEItemKey itemKey;
        if (stack.isEmpty()) {
            return null;
        }
        GenericStack unwrappedStack = GenericStack.unwrapItemStack((ItemStack)stack);
        ItemStack returnStack = stack;
        if (unwrappedStack != null) {
            AEKey aEKey = unwrappedStack.what();
            if (aEKey instanceof AEItemKey) {
                itemKey = (AEItemKey)aEKey;
                returnStack = itemKey.toStack(Math.max(1, Ints.saturatedCast((long)unwrappedStack.amount())));
            } else {
                return unwrappedStack;
            }
        }
        return (itemKey = AEItemKey.of((ItemStack)returnStack)) != null ? new GenericStack((AEKey)itemKey, (long)returnStack.getCount()) : null;
    }
}

