/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.network;

import com.almostreliable.merequester.network.DragAndDropPacket;
import com.almostreliable.merequester.network.RequestUpdatePacket;
import com.almostreliable.merequester.network.RequesterSyncPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public final class PacketHandler {
    private static final String PROTOCOL = "1";

    private PacketHandler() {
    }

    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(PacketHandler::onPacketRegistration);
    }

    private static void onPacketRegistration(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(PROTOCOL);
        registrar.playToClient(RequesterSyncPacket.TYPE, RequesterSyncPacket.STREAM_CODEC, PacketHandler.wrapHandler(RequesterSyncPacket::handle));
        registrar.playToServer(RequestUpdatePacket.TYPE, RequestUpdatePacket.STREAM_CODEC, PacketHandler.wrapHandler(RequestUpdatePacket::handle));
        registrar.playToServer(DragAndDropPacket.TYPE, DragAndDropPacket.STREAM_CODEC, PacketHandler.wrapHandler(DragAndDropPacket::handle));
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> wrapHandler(IPayloadHandler<T> handler) {
        return (payload, context) -> context.enqueueWork(() -> handler.handle(payload, context));
    }
}

