/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.JigsawStructureAccessor;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.structure.AlternateJigsawStructure;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public record SetPoolAliasesModifier(HolderSet<Structure> structures, List<PoolAliasBinding> poolAliases, boolean append) implements Modifier
{
    public static final MapCodec<SetPoolAliasesModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LithostitchedCodecs.registrySet(Registries.STRUCTURE, "structures").forGetter(SetPoolAliasesModifier::structures), (App)Codec.list((Codec)PoolAliasBinding.CODEC).fieldOf("pool_aliases").forGetter(SetPoolAliasesModifier::poolAliases), (App)Codec.BOOL.fieldOf("append").orElse((Object)true).forGetter(SetPoolAliasesModifier::append)).apply((Applicative)instance, SetPoolAliasesModifier::new)).validate(SetPoolAliasesModifier::validate);

    private static DataResult<SetPoolAliasesModifier> validate(SetPoolAliasesModifier modifier) {
        for (Holder holder : modifier.structures) {
            Structure structure = (Structure)holder.value();
            if (structure instanceof JigsawStructure || structure instanceof AlternateJigsawStructure) continue;
            return DataResult.error(() -> "Target structure for pool alias additions should be a jigsaw structure");
        }
        return DataResult.success((Object)modifier);
    }

    @Override
    public Modifier.ModifierPhase getPhase() {
        return this.append ? Modifier.ModifierPhase.REPLACE : Modifier.ModifierPhase.ADD;
    }

    @Override
    public void applyModifier() {
        this.structures.stream().map(Holder::value).forEach(this::applyModifier);
    }

    private void applyModifier(Structure structure) {
        if (structure instanceof AlternateJigsawStructure) {
            AlternateJigsawStructure alternateJigsaw = (AlternateJigsawStructure)structure;
            alternateJigsaw.setPoolAliases(this.poolAliases, this.append);
        } else {
            ArrayList<PoolAliasBinding> mergedAliases = new ArrayList<PoolAliasBinding>();
            if (this.append) {
                mergedAliases.addAll(((JigsawStructureAccessor)structure).getPoolAliases());
            }
            mergedAliases.addAll(this.poolAliases);
            ((JigsawStructureAccessor)structure).setPoolAliases(mergedAliases);
        }
    }

    @Override
    public MapCodec<? extends Modifier> codec() {
        return CODEC;
    }
}

