/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.worldgen.lithostitched.mixin.common.ChunkGeneratorAccessor;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import dev.worldgen.lithostitched.worldgen.modifier.PriorityBasedModifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.dimension.LevelStem;
import org.jetbrains.annotations.NotNull;

public interface Modifier {
    public static final Codec<Modifier> CODEC = Codec.lazyInitialized(() -> {
        Registry modifierRegistry = (Registry)BuiltInRegistries.REGISTRY.get(LithostitchedRegistryKeys.MODIFIER_TYPE.location());
        if (modifierRegistry == null) {
            throw new NullPointerException("Worldgen modifier registry does not exist yet!");
        }
        return modifierRegistry.byNameCodec();
    }).dispatch(Modifier::codec, Function.identity());

    default public void applyModifier(RegistryAccess registryAccess) {
        this.applyModifier();
    }

    public void applyModifier();

    public ModifierPhase getPhase();

    public MapCodec<? extends Modifier> codec();

    public static void applyModifiers(MinecraftServer server) {
        boolean fabricFeaturesModified = false;
        RegistryAccess.Frozen registries = server.registryAccess();
        Registry modifiers = registries.registryOrThrow(LithostitchedRegistryKeys.WORLDGEN_MODIFIER);
        for (ModifierPhase phase : ModifierPhase.values()) {
            if (phase == ModifierPhase.NONE) continue;
            List<Modifier> phaseModifiers = modifiers.stream().filter(modifier -> modifier.getPhase() == phase).toList();
            Modifier.applyPhaseModifiers((RegistryAccess)registries, phaseModifiers);
            if (phaseModifiers.stream().filter(Modifier::internal$modifiesFabricFeatures).toList().isEmpty()) continue;
            fabricFeaturesModified = true;
        }
        if (fabricFeaturesModified) {
            Registry dimensions = registries.registryOrThrow(Registries.LEVEL_STEM);
            for (LevelStem dimension : dimensions) {
                ChunkGeneratorAccessor accessor = (ChunkGeneratorAccessor)dimension.generator();
                BiomeSource source = accessor.getBiomeSource();
                accessor.setFeaturesPerStep((Supplier<List<FeatureSorter.StepFeatureData>>)Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(source.possibleBiomes()), biome -> accessor.getGetter().apply((Holder<Biome>)biome).features(), (boolean)true)));
            }
        }
    }

    private static void applyPhaseModifiers(RegistryAccess registries, List<Modifier> phaseModifiers) {
        ArrayList<PriorityBasedModifier> priorityBasedModifiers = new ArrayList<PriorityBasedModifier>();
        for (Modifier modifier : phaseModifiers) {
            if (modifier instanceof PriorityBasedModifier) {
                PriorityBasedModifier priorityModifier = (PriorityBasedModifier)modifier;
                priorityBasedModifiers.add(priorityModifier);
                continue;
            }
            modifier.applyModifier(registries);
        }
        for (Modifier modifier : Modifier.sortByPriority(priorityBasedModifiers)) {
            modifier.applyModifier(registries);
        }
    }

    public static List<PriorityBasedModifier> sortByPriority(List<PriorityBasedModifier> modifiers) {
        return modifiers.stream().sorted(Comparator.comparingInt(PriorityBasedModifier::getPriority)).toList();
    }

    default public boolean internal$modifiesFabricFeatures() {
        return false;
    }

    public static enum ModifierPhase implements StringRepresentable
    {
        NONE("none"),
        BEFORE_ALL("before_all"),
        REPLACE("replace"),
        ADD("add"),
        REMOVE("remove"),
        MODIFY("modify"),
        AFTER_ALL("after_all");

        private final String name;

        private ModifierPhase(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

