/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.blockpredicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;

public record MultipleOfPredicate(List<BlockPredicate> predicates, InclusiveRange<Integer> allowedCount) implements BlockPredicate
{
    public static final MapCodec<MultipleOfPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockPredicate.CODEC.listOf().fieldOf("predicates").forGetter(MultipleOfPredicate::predicates), (App)InclusiveRange.INT.fieldOf("allowed_count").forGetter(MultipleOfPredicate::allowedCount)).apply((Applicative)instance, MultipleOfPredicate::new));
    public static final BlockPredicateType<MultipleOfPredicate> TYPE = () -> CODEC;

    public boolean test(WorldGenLevel level, BlockPos pos) {
        int count = 0;
        for (BlockPredicate predicate : this.predicates) {
            if (!predicate.test((Object)level, (Object)pos) || (Integer)this.allowedCount.maxInclusive() >= ++count) continue;
            return false;
        }
        return this.allowedCount.isValueInRange((Comparable)Integer.valueOf(count));
    }

    public BlockPredicateType<?> type() {
        return TYPE;
    }
}

