/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.biome.BiomeEffects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeSpecialEffectsBuilder;
import net.neoforged.neoforge.common.world.ClimateSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public class LithostitchedNeoforgeBiomeModifiers {

    public record ReplaceEffectsBiomeModifier(HolderSet<Biome> biomes, BiomeEffects specialEffects) implements BiomeModifier
    {
        public static final MapCodec<ReplaceEffectsBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(ReplaceEffectsBiomeModifier::biomes), (App)BiomeEffects.CODEC.fieldOf("effects").forGetter(ReplaceEffectsBiomeModifier::specialEffects)).apply((Applicative)builder, ReplaceEffectsBiomeModifier::new));

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.MODIFY && this.biomes().contains(biome)) {
                BiomeSpecialEffectsBuilder effects = builder.getSpecialEffects();
                if (this.specialEffects.skyColor().isPresent()) {
                    effects.skyColor(this.specialEffects.skyColor().get().intValue());
                }
                if (this.specialEffects.fogColor().isPresent()) {
                    effects.skyColor(this.specialEffects.fogColor().get().intValue());
                }
                if (this.specialEffects.waterColor().isPresent()) {
                    effects.skyColor(this.specialEffects.waterColor().get().intValue());
                }
                if (this.specialEffects.waterFogColor().isPresent()) {
                    effects.skyColor(this.specialEffects.waterFogColor().get().intValue());
                }
                if (this.specialEffects.grassColorOverride().isPresent()) {
                    effects.grassColorOverride(this.specialEffects.grassColorOverride().get().intValue());
                }
                if (this.specialEffects.foliageColorOverride().isPresent()) {
                    effects.grassColorOverride(this.specialEffects.foliageColorOverride().get().intValue());
                }
                effects.grassColorModifier(this.specialEffects.grassColorModifier());
                if (this.specialEffects.ambientLoopSoundEvent().isPresent()) {
                    effects.ambientLoopSound(this.specialEffects.ambientLoopSoundEvent().get());
                }
                if (this.specialEffects.ambientMoodSettings().isPresent()) {
                    effects.ambientMoodSound(this.specialEffects.ambientMoodSettings().get());
                }
                if (this.specialEffects.ambientAdditionsSettings().isPresent()) {
                    effects.ambientAdditionsSound(this.specialEffects.ambientAdditionsSettings().get());
                }
                if (this.specialEffects.backgroundMusic().isPresent()) {
                    effects.backgroundMusic(this.specialEffects.backgroundMusic().get());
                }
                if (this.specialEffects.ambientParticleSettings().isPresent()) {
                    effects.ambientParticle(this.specialEffects.ambientParticleSettings().get());
                }
            }
        }

        public MapCodec<? extends BiomeModifier> codec() {
            return CODEC;
        }
    }

    public record ReplaceClimateBiomeModifier(HolderSet<Biome> biomes, Biome.ClimateSettings climateSettings) implements BiomeModifier
    {
        public static final MapCodec<ReplaceClimateBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(ReplaceClimateBiomeModifier::biomes), (App)Biome.ClimateSettings.CODEC.fieldOf("climate").forGetter(ReplaceClimateBiomeModifier::climateSettings)).apply((Applicative)builder, ReplaceClimateBiomeModifier::new));

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.MODIFY && this.biomes().contains(biome)) {
                ClimateSettingsBuilder climateSettings = builder.getClimateSettings();
                climateSettings.setTemperature(this.climateSettings().temperature());
                climateSettings.setDownfall(this.climateSettings().downfall());
                climateSettings.setHasPrecipitation(this.climateSettings().hasPrecipitation());
                climateSettings.setTemperatureModifier(this.climateSettings().temperatureModifier());
            }
        }

        public MapCodec<? extends BiomeModifier> codec() {
            return CODEC;
        }
    }
}

