/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.paygate;

import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketCollectTicketStubs
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketCollectTicketStubs> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_paygate_collect_tickets"));
    public static final CustomPacket.Handler<CPacketCollectTicketStubs> HANDLER = new H();
    private final long traderID;

    public CPacketCollectTicketStubs(long traderID) {
        super(TYPE);
        this.traderID = traderID;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketCollectTicketStubs message) {
        buffer.writeLong(message.traderID);
    }

    private static CPacketCollectTicketStubs decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketCollectTicketStubs(buffer.readLong());
    }

    private static class H
    extends CustomPacket.Handler<CPacketCollectTicketStubs> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketCollectTicketStubs::encode, CPacketCollectTicketStubs::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketCollectTicketStubs message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            TraderData traderData = TraderAPI.API.GetTrader(false, message.traderID);
            if (traderData instanceof PaygateTraderData) {
                PaygateTraderData paygate = (PaygateTraderData)traderData;
                paygate.collectTicketStubs(player);
            }
        }
    }
}

