/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.network.message.data.CPacketAcknowledgeCoinData;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public final class SPacketSyncCoinData
extends ServerToClientPacket {
    public static final ConfigurationTask.Type CONFIG_TYPE = new ConfigurationTask.Type(VersionUtil.lcResource("send_coin_data"));
    private static final CustomPacketPayload.Type<SPacketSyncCoinData> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("s_sync_master_coin_list"));
    public static final CustomPacket.ConfigHandler<SPacketSyncCoinData> HANDLER = new H();
    private static final Gson GSON = new GsonBuilder().create();
    private final JsonObject json;
    private boolean isConfigTask = false;

    public JsonObject getJson() {
        return this.json;
    }

    public SPacketSyncCoinData configTask() {
        this.isConfigTask = true;
        return this;
    }

    public SPacketSyncCoinData(@Nonnull JsonObject json) {
        super(TYPE);
        this.json = json;
    }

    private SPacketSyncCoinData(@Nonnull JsonObject json, boolean isConfigTask) {
        this(json);
        this.isConfigTask = isConfigTask;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull SPacketSyncCoinData message) {
        String jsonString = GSON.toJson((JsonElement)message.json);
        buffer.writeInt(jsonString.length());
        buffer.writeUtf(jsonString, jsonString.length());
        buffer.writeBoolean(message.isConfigTask);
    }

    private static SPacketSyncCoinData decode(@Nonnull FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        String string = buffer.readUtf(size);
        return new SPacketSyncCoinData(GsonHelper.parse((String)string).getAsJsonObject(), buffer.readBoolean());
    }

    private static class H
    extends CustomPacket.ConfigHandler<SPacketSyncCoinData> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(SPacketSyncCoinData::encode, SPacketSyncCoinData::decode));
        }

        public void handle(@Nonnull SPacketSyncCoinData message, @Nonnull IPayloadContext context) {
            CoinAPI.API.HandleSyncPacket(message);
            if (message.isConfigTask) {
                context.reply((CustomPacketPayload)new CPacketAcknowledgeCoinData());
            }
        }
    }
}

