/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.command;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SPacketDebugTrader
extends ServerToClientPacket {
    private static final CustomPacketPayload.Type<SPacketDebugTrader> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("s_debug_trader_data"));
    public static final CustomPacket.Handler<SPacketDebugTrader> HANDLER = new H();
    final long traderID;

    public SPacketDebugTrader(long traderID) {
        super(TYPE);
        this.traderID = traderID;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull SPacketDebugTrader message) {
        buffer.writeLong(message.traderID);
    }

    private static SPacketDebugTrader decode(@Nonnull FriendlyByteBuf buffer) {
        return new SPacketDebugTrader(buffer.readLong());
    }

    private static class H
    extends CustomPacket.Handler<SPacketDebugTrader> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(SPacketDebugTrader::encode, SPacketDebugTrader::decode));
        }

        @Override
        protected void handle(@Nonnull SPacketDebugTrader message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            TraderData trader = TraderAPI.API.GetTrader(true, message.traderID);
            if (trader == null) {
                LightmansCurrency.LogInfo("Client is missing trader with id " + message.traderID + "!");
            } else {
                LightmansCurrency.LogInfo("Client Trader NBT for trader " + message.traderID + ":\n" + String.valueOf(trader.save((HolderLookup.Provider)player.registryAccess())));
            }
        }
    }
}

