/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.auction;

import io.github.lightman314.lightmanscurrency.common.blockentity.AuctionStandBlockEntity;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SPacketSyncAuctionStandDisplay
extends ServerToClientPacket {
    private static final CustomPacketPayload.Type<SPacketSyncAuctionStandDisplay> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("s_auction_stand_sync"));
    public static final CustomPacket.Handler<SPacketSyncAuctionStandDisplay> HANDLER = new H();
    private final List<ItemStack> items;

    public SPacketSyncAuctionStandDisplay(List<ItemStack> items) {
        super(TYPE);
        this.items = InventoryUtil.copyList(items);
    }

    private static void encode(@Nonnull RegistryFriendlyByteBuf buffer, @Nonnull SPacketSyncAuctionStandDisplay message) {
        buffer.writeInt(message.items.size());
        for (ItemStack item : message.items) {
            SPacketSyncAuctionStandDisplay.writeItem(buffer, item);
        }
    }

    private static SPacketSyncAuctionStandDisplay decode(@Nonnull RegistryFriendlyByteBuf buffer) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            items.add(SPacketSyncAuctionStandDisplay.readItem(buffer));
        }
        return new SPacketSyncAuctionStandDisplay(items);
    }

    private static class H
    extends CustomPacket.Handler<SPacketSyncAuctionStandDisplay> {
        protected H() {
            super(TYPE, CustomPacket.fancyCodec(SPacketSyncAuctionStandDisplay::encode, SPacketSyncAuctionStandDisplay::decode));
        }

        @Override
        protected void handle(@Nonnull SPacketSyncAuctionStandDisplay message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            AuctionStandBlockEntity.syncItemsFromServer(message.items);
        }
    }
}

