/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.crafting;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.conditions.ConfigCraftingCondition;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.BooleanOption;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.common.crafting.condition.LCCraftingConditions;
import io.github.lightman314.lightmanscurrency.datagen.common.crafting.builders.MasterTicketRecipeBuilder;
import io.github.lightman314.lightmanscurrency.datagen.common.crafting.builders.MintRecipeBuilder;
import io.github.lightman314.lightmanscurrency.datagen.common.crafting.builders.TicketRecipeBuilder;
import io.github.lightman314.lightmanscurrency.datagen.common.crafting.builders.WalletUpgradeRecipeBuilder;
import io.github.lightman314.lightmanscurrency.datagen.util.ColorHelper;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class LCRecipeProvider
extends RecipeProvider {
    private static final String ADV_PREFIX = "recipes/misc/";

    public LCRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(output, pRegistries);
    }

    protected void buildRecipes(@Nonnull RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.TRADING_CORE.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).pattern("rqr").pattern("rdr").pattern("rpr").define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('q'), Tags.Items.GEMS_QUARTZ).define(Character.valueOf('d'), (ItemLike)Items.DROPPER).define(Character.valueOf('p'), (ItemLike)Items.COMPARATOR).save(consumer, LCRecipeProvider.ItemID(ModItems.TRADING_CORE));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ATM.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).pattern("igi").pattern("igi").pattern("iri").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('g'), Tags.Items.GLASS_PANES_COLORLESS).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).save(consumer, LCRecipeProvider.ItemID(ModBlocks.ATM));
        LCRecipeProvider.GenerateSwapRecipes(consumer, (ItemLike)ModBlocks.ATM.get(), (ItemLike)ModItems.PORTABLE_ATM.get(), Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"money", LCRecipeProvider.MoneyKnowledge())}));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.TERMINAL.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("sgs").pattern("sgs").pattern("iei").define(Character.valueOf('e'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('s'), Tags.Items.STONES).save(consumer, LCRecipeProvider.ItemID(ModBlocks.TERMINAL));
        LCRecipeProvider.GenerateSwapRecipes(consumer, (ItemLike)ModBlocks.TERMINAL.get(), (ItemLike)ModItems.PORTABLE_TERMINAL.get(), Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"money", LCRecipeProvider.MoneyKnowledge()), Pair.of((Object)"trader", LCRecipeProvider.TraderKnowledge())}));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.GEM_TERMINAL.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("aaa").pattern("aea").pattern("asa").define(Character.valueOf('e'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('a'), Tags.Items.GEMS_AMETHYST).define(Character.valueOf('s'), Tags.Items.STONES).save(consumer, LCRecipeProvider.ItemID(ModBlocks.GEM_TERMINAL));
        LCRecipeProvider.GenerateSwapRecipes(consumer, (ItemLike)ModBlocks.GEM_TERMINAL.get(), (ItemLike)ModItems.PORTABLE_GEM_TERMINAL.get(), Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"money", LCRecipeProvider.MoneyKnowledge()), Pair.of((Object)"trader", LCRecipeProvider.TraderKnowledge())}));
        LCRecipeProvider.GenerateWalletRecipes(consumer, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER), ModItems.WALLET_COPPER), Pair.of((Object)Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), ModItems.WALLET_IRON), Pair.of((Object)Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), ModItems.WALLET_GOLD), Pair.of((Object)Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD), ModItems.WALLET_EMERALD), Pair.of((Object)Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), ModItems.WALLET_DIAMOND), Pair.of((Object)Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE), ModItems.WALLET_NETHERITE), Pair.of((Object)Ingredient.of((TagKey)Tags.Items.NETHER_STARS), ModItems.WALLET_NETHER_STAR)}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.WALLET_LEATHER.get())).group("wallet_crafting").unlockedBy("coin", LCRecipeProvider.MoneyKnowledge()).unlockedBy("wallet", LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).requires(Tags.Items.LEATHERS).requires(Tags.Items.STRINGS).requires(Tags.Items.LEATHERS).save(consumer, LCRecipeProvider.ItemID("wallet/", ModItems.WALLET_LEATHER));
        WalletUpgradeRecipeBuilder.shapeless(RecipeCategory.MISC, (ItemLike)ModItems.WALLET_IRON.get()).group("wallet_crafting").unlockedBy("coin", (Criterion)LCRecipeProvider.MoneyKnowledge()).unlockedBy("wallet", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).requires((ItemLike)ModItems.WALLET_LEATHER.get()).requires((TagKey<Item>)Tags.Items.INGOTS_IRON).save(consumer, LCRecipeProvider.ItemID("wallet/upgrade_leather_wallet_to_", ModItems.WALLET_IRON));
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_COPPER, ModBlocks.COINPILE_COPPER, ModBlocks.COINBLOCK_COPPER);
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_IRON, ModBlocks.COINPILE_IRON, ModBlocks.COINBLOCK_IRON);
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_GOLD, ModBlocks.COINPILE_GOLD, ModBlocks.COINBLOCK_GOLD);
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_EMERALD, ModBlocks.COINPILE_EMERALD, ModBlocks.COINBLOCK_EMERALD);
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_DIAMOND, ModBlocks.COINPILE_DIAMOND, ModBlocks.COINBLOCK_DIAMOND);
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_NETHERITE, ModBlocks.COINPILE_NETHERITE, ModBlocks.COINBLOCK_NETHERITE);
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_CHOCOLATE_COPPER, ModBlocks.COINPILE_CHOCOLATE_COPPER, ModBlocks.COINBLOCK_CHOCOLATE_COPPER, "chocolate_", LCRecipeProvider.LazyTrigger(LCTags.Items.EVENT_COIN_CHOCOLATE));
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_CHOCOLATE_IRON, ModBlocks.COINPILE_CHOCOLATE_IRON, ModBlocks.COINBLOCK_CHOCOLATE_IRON, "chocolate_", LCRecipeProvider.LazyTrigger(LCTags.Items.EVENT_COIN_CHOCOLATE));
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_CHOCOLATE_GOLD, ModBlocks.COINPILE_CHOCOLATE_GOLD, ModBlocks.COINBLOCK_CHOCOLATE_GOLD, "chocolate_", LCRecipeProvider.LazyTrigger(LCTags.Items.EVENT_COIN_CHOCOLATE));
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_CHOCOLATE_EMERALD, ModBlocks.COINPILE_CHOCOLATE_EMERALD, ModBlocks.COINBLOCK_CHOCOLATE_EMERALD, "chocolate_", LCRecipeProvider.LazyTrigger(LCTags.Items.EVENT_COIN_CHOCOLATE));
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_CHOCOLATE_DIAMOND, ModBlocks.COINPILE_CHOCOLATE_DIAMOND, ModBlocks.COINBLOCK_CHOCOLATE_DIAMOND, "chocolate_", LCRecipeProvider.LazyTrigger(LCTags.Items.EVENT_COIN_CHOCOLATE));
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_CHOCOLATE_NETHERITE, ModBlocks.COINPILE_CHOCOLATE_NETHERITE, ModBlocks.COINBLOCK_CHOCOLATE_NETHERITE, "chocolate_", LCRecipeProvider.LazyTrigger(LCTags.Items.EVENT_COIN_CHOCOLATE));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.COIN_MINT.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("material", LCRecipeProvider.LazyTrigger(LCTags.Items.COIN_MINTING_MATERIAL)).pattern("ipi").pattern("i i").pattern("sss").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('p'), (ItemLike)Items.PISTON).define(Character.valueOf('s'), (ItemLike)Items.SMOOTH_STONE).save(consumer.withConditions(new ICondition[]{ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinMint)}), LCRecipeProvider.ItemID(ModBlocks.COIN_MINT));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.TICKET_STATION.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("ticket_trader", LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_KIOSK)).unlockedBy("ticket", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).pattern("igi").pattern("igi").pattern("rrr").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('g'), (ItemLike)Items.INK_SAC).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).save(consumer, LCRecipeProvider.ID("ticket_station"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.CASH_REGISTER.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("iii").pattern("ede").pattern("iii").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('e'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('d'), (ItemLike)Items.DROPPER).save(consumer, LCRecipeProvider.ItemID(ModBlocks.CASH_REGISTER));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.COIN_CHEST.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).pattern("ppp").pattern("prp").pattern("ppp").define(Character.valueOf('p'), ItemTags.PLANKS).define(Character.valueOf('r'), (ItemLike)Items.COMPARATOR).save(consumer.withConditions(new ICondition[]{ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChest)}), LCRecipeProvider.ItemID(ModBlocks.COIN_CHEST));
        ModBlocks.DISPLAY_CASE.forEach((color, display) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)display.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("g").pattern("x").pattern("w").define(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('w'), (ItemLike)ColorHelper.GetWoolOfColor(color)).save(consumer, LCRecipeProvider.ID("traders/display_case/" + color.getResourceSafeName())));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.VENDING_MACHINE.get(Color.WHITE))).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("igi").pattern("igi").pattern("cxc").define(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).save(consumer, LCRecipeProvider.ItemID("traders/", (ItemLike)ModBlocks.VENDING_MACHINE.get(Color.WHITE)));
        LCRecipeProvider.GenerateColoredDyeAndWashRecipes(consumer, ModBlocks.VENDING_MACHINE, (ItemLike)ModBlocks.VENDING_MACHINE.get(Color.WHITE), "vending_machine_dyes", "traders/vending_machine/", Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"money", LCRecipeProvider.MoneyKnowledge()), Pair.of((Object)"trader", LCRecipeProvider.TraderKnowledge())}));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Color.WHITE))).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).unlockedBy("vending_machine", LCRecipeProvider.LazyTrigger((ItemLike)ModBlocks.VENDING_MACHINE.get(Color.WHITE))).pattern("igi").pattern("igi").pattern("cxc").define(Character.valueOf('x'), (ItemLike)ModBlocks.VENDING_MACHINE.get(Color.WHITE)).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).save(consumer, LCRecipeProvider.ItemID("traders/", (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Color.WHITE)));
        LCRecipeProvider.GenerateColoredDyeAndWashRecipes(consumer, ModBlocks.VENDING_MACHINE_LARGE, (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Color.WHITE), "vending_machine_large_dyes", "traders/large_vending_machine/", Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"money", LCRecipeProvider.MoneyKnowledge()), Pair.of((Object)"trader", LCRecipeProvider.TraderKnowledge())}));
        ModBlocks.SHELF.forEach((woodType, shelf) -> {
            Item slab;
            ModLoadedCondition condition = woodType.isVanilla() ? null : new ModLoadedCondition(woodType.getModID());
            WoodData data = woodType.getData();
            Item item = slab = data == null ? null : data.getSlab();
            if (slab != null) {
                ResourceLocation id = LCRecipeProvider.WoodID("traders/shelf/", woodType);
                ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)shelf.get())).group("shelf_trader").unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("x").pattern("s").define(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).define(Character.valueOf('s'), (ItemLike)slab);
                if (condition != null) {
                    builder.save(consumer.withConditions(new ICondition[]{condition}), id);
                } else {
                    builder.save(consumer, id);
                }
            } else {
                LightmansCurrency.LogDebug("Could not generate shelf recipe for WoodType '" + woodType.id + "' as it has no defined slab item.");
            }
        });
        ModBlocks.SHELF_2x2.forEach((woodType, shelf) -> {
            ModLoadedCondition condition = woodType.isVanilla() ? null : new ModLoadedCondition(woodType.getModID());
            WoodData data = woodType.getData();
            Item slab = data == null ? null : data.getSlab();
            ItemLike trader = (ItemLike)ModBlocks.SHELF.get((WoodType)woodType);
            if (slab != null && trader != null) {
                ResourceLocation id = LCRecipeProvider.WoodID("traders/shelf2/", woodType);
                ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)shelf.get())).group("shelf_trader_2x2").unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).unlockedBy("shelf", LCRecipeProvider.LazyTrigger(trader)).pattern("c").pattern("x").pattern("s").define(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('x'), trader).define(Character.valueOf('s'), (ItemLike)slab);
                if (condition != null) {
                    builder.save(consumer.withConditions(new ICondition[]{condition}), id);
                } else {
                    builder.save(consumer, id);
                }
            } else {
                LightmansCurrency.LogDebug("Could not generate 2x2 shelf recipe for WoodType '" + woodType.id + "' as it has no defined slab item.");
            }
        });
        ModBlocks.CARD_DISPLAY.forEach((woodType, color, card_display) -> {
            Item log;
            ModLoadedCondition condition = woodType.isVanilla() ? null : new ModLoadedCondition(woodType.getModID());
            WoodData data = woodType.getData();
            Item item = log = data == null ? null : data.getLog();
            if (log != null) {
                ResourceLocation id = LCRecipeProvider.ColoredWoodID("traders/card_display/", woodType, color);
                ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)card_display.get())).group("card_display_trader_" + woodType.id).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("  w").pattern(" xl").pattern("llc").define(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).define(Character.valueOf('l'), (ItemLike)log).define(Character.valueOf('w'), (ItemLike)ColorHelper.GetWoolOfColor(color)).define(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN);
                if (condition != null) {
                    builder.save(consumer.withConditions(new ICondition[]{condition}), id);
                } else {
                    builder.save(consumer, id);
                }
            } else {
                LightmansCurrency.LogDebug("Could not generate card display recipe for WoodType '" + woodType.id + "' as it has no defined log item.");
            }
        });
        for (Color c : Color.values()) {
            Item cp = ColorHelper.GetConcretePowderOfColor(c);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.FREEZER.get(c))).group("freezer_crafting").unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("igi").pattern("igi").pattern("cxc").define(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('i'), (ItemLike)cp).define(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).save(consumer, LCRecipeProvider.ID("traders/freezer/" + c.getResourceSafeName()));
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ITEM_NETWORK_TRADER_1.get())).group("item_network_trader").unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).unlockedBy("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).pattern("ici").pattern("ixi").pattern("iei").define(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).define(Character.valueOf('e'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).save(consumer.withConditions(new ICondition[]{LCCraftingConditions.NETWORK_TRADER}), LCRecipeProvider.ID("network/item_network_trader_1"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ITEM_NETWORK_TRADER_2.get())).group("item_network_trader").unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).unlockedBy("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).unlockedBy("previous", LCRecipeProvider.LazyTrigger(ModBlocks.ITEM_NETWORK_TRADER_1)).pattern("c").pattern("x").pattern("i").define(Character.valueOf('x'), (ItemLike)ModBlocks.ITEM_NETWORK_TRADER_1.get()).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).save(consumer.withConditions(new ICondition[]{LCCraftingConditions.NETWORK_TRADER}), LCRecipeProvider.ID("network/item_network_trader_2"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ITEM_NETWORK_TRADER_3.get())).group("item_network_trader").unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).unlockedBy("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).unlockedBy("previous", LCRecipeProvider.LazyTrigger(ModBlocks.ITEM_NETWORK_TRADER_2)).pattern("c").pattern("x").pattern("i").define(Character.valueOf('x'), (ItemLike)ModBlocks.ITEM_NETWORK_TRADER_2.get()).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).save(consumer.withConditions(new ICondition[]{LCCraftingConditions.NETWORK_TRADER}), LCRecipeProvider.ID("network/item_network_trader_3"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ITEM_NETWORK_TRADER_4.get())).group("item_network_trader").unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).unlockedBy("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).unlockedBy("previous", LCRecipeProvider.LazyTrigger(ModBlocks.ITEM_NETWORK_TRADER_3)).pattern("c").pattern("x").pattern("i").define(Character.valueOf('x'), (ItemLike)ModBlocks.ITEM_NETWORK_TRADER_3.get()).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).save(consumer.withConditions(new ICondition[]{LCCraftingConditions.NETWORK_TRADER}), LCRecipeProvider.ID("network/item_network_trader_4"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ARMOR_DISPLAY.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("ggg").pattern("gag").pattern("ixi").define(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('a'), (ItemLike)Items.ARMOR_STAND).save(consumer, LCRecipeProvider.ItemID("traders/", ModBlocks.ARMOR_DISPLAY));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.TICKET_KIOSK.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("iii").pattern("igi").pattern("rxr").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('g'), (ItemLike)Items.INK_SAC).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).save(consumer, LCRecipeProvider.ItemID("traders/", ModBlocks.TICKET_KIOSK));
        ModBlocks.BOOKSHELF_TRADER.forEach((woodType, bookshelf) -> {
            Item slab;
            ModLoadedCondition condition = woodType.isVanilla() ? null : new ModLoadedCondition(woodType.getModID());
            WoodData data = woodType.getData();
            Item plank = data == null ? null : data.getPlank();
            Item item = slab = data == null ? null : data.getSlab();
            if (plank != null && slab != null) {
                ResourceLocation id = LCRecipeProvider.WoodID("traders/bookshelf/", woodType);
                ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)bookshelf.get())).group("bookshelf_trader").unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("ppp").pattern("sxs").pattern("ppp").define(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).define(Character.valueOf('p'), (ItemLike)plank).define(Character.valueOf('s'), (ItemLike)slab);
                if (condition == null) {
                    builder.save(consumer, id);
                } else {
                    builder.save(consumer.withConditions(new ICondition[]{condition}), id);
                }
            } else {
                LightmansCurrency.LogDebug("Could not generate bookshelf recipe for WoodType '" + woodType.id + "' as it has no defined plank and/or slab item.");
            }
        });
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.SLOT_MACHINE.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("igi").pattern("idi").pattern("rxr").define(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('r'), (ItemLike)Items.COMPARATOR).define(Character.valueOf('d'), Tags.Items.DUSTS_GLOWSTONE).save(consumer, LCRecipeProvider.ItemID("traders/", ModBlocks.SLOT_MACHINE));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.PAYGATE.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).unlockedBy("ticket", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).pattern("iri").pattern("ixi").pattern("iti").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('t'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('r'), (ItemLike)Items.REDSTONE_BLOCK).define(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).save(consumer, LCRecipeProvider.ItemID("traders/", ModBlocks.PAYGATE));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ITEM_TRADER_INTERFACE.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).unlockedBy("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).pattern("ici").pattern("iti").pattern("ici").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('t'), LCTags.Items.NETWORK_TERMINAL).define(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).save(consumer.withConditions(new ICondition[]{LCCraftingConditions.TRADER_INTERFACE}), LCRecipeProvider.ItemID(ModBlocks.ITEM_TRADER_INTERFACE));
        ModBlocks.AUCTION_STAND.forEach((woodType, auction_stand) -> {
            Item log;
            ICondition[] iConditionArray;
            if (woodType.isModded()) {
                ICondition[] iConditionArray2 = new ICondition[2];
                iConditionArray2[0] = new ModLoadedCondition(woodType.getModID());
                iConditionArray = iConditionArray2;
                iConditionArray2[1] = ConfigCraftingCondition.of(LCConfig.COMMON.canCraftAuctionStands);
            } else {
                ICondition[] iConditionArray3 = new ICondition[1];
                iConditionArray = iConditionArray3;
                iConditionArray3[0] = ConfigCraftingCondition.of(LCConfig.COMMON.canCraftAuctionStands);
            }
            ICondition[] conditions = iConditionArray;
            WoodData data = woodType.getData();
            Item item = log = data == null ? null : data.getLog();
            if (log != null) {
                ResourceLocation id = LCRecipeProvider.WoodID("auction_stand/", woodType);
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)auction_stand.get())).group("auction_stand").unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).unlockedBy("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).pattern("g").pattern("x").pattern("l").define(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('l'), (ItemLike)log).save(consumer.withConditions(conditions), id);
            } else {
                LightmansCurrency.LogDebug("Could not generate auction stand recipe for WoodType '" + woodType.id + "' as it has no defined log item.");
            }
        });
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.PIGGY_BANK.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("wallet", LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).pattern("b  ").pattern("bbb").pattern("bdb").define(Character.valueOf('b'), Tags.Items.BRICKS).define(Character.valueOf('d'), Tags.Items.DYES_PINK).save(consumer, LCRecipeProvider.ItemID("coin_jar/", ModBlocks.PIGGY_BANK));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.COINJAR_BLUE.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("wallet", LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).pattern("b b").pattern("bdb").pattern(" b ").define(Character.valueOf('b'), Tags.Items.BRICKS).define(Character.valueOf('d'), Tags.Items.DYES_BLUE).save(consumer, LCRecipeProvider.ID("coin_jar/blue"));
        LCRecipeProvider.GenerateMintAndMeltRecipes(consumer, ModItems.COIN_COPPER, (TagKey<Item>)Tags.Items.INGOTS_COPPER, (ItemLike)Items.COPPER_INGOT, LCConfig.COMMON.coinMintMintableCopper, LCConfig.COMMON.coinMintMeltableCopper);
        LCRecipeProvider.GenerateMintAndMeltRecipes(consumer, ModItems.COIN_IRON, (TagKey<Item>)Tags.Items.INGOTS_IRON, (ItemLike)Items.IRON_INGOT, LCConfig.COMMON.coinMintMintableIron, LCConfig.COMMON.coinMintMeltableIron);
        LCRecipeProvider.GenerateMintAndMeltRecipes(consumer, ModItems.COIN_GOLD, (TagKey<Item>)Tags.Items.INGOTS_GOLD, (ItemLike)Items.GOLD_INGOT, LCConfig.COMMON.coinMintMintableGold, LCConfig.COMMON.coinMintMeltableGold);
        LCRecipeProvider.GenerateMintAndMeltRecipes(consumer, ModItems.COIN_EMERALD, (TagKey<Item>)Tags.Items.GEMS_EMERALD, (ItemLike)Items.EMERALD, LCConfig.COMMON.coinMintMintableEmerald, LCConfig.COMMON.coinMintMeltableEmerald);
        LCRecipeProvider.GenerateMintAndMeltRecipes(consumer, ModItems.COIN_DIAMOND, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, (ItemLike)Items.DIAMOND, LCConfig.COMMON.coinMintMintableDiamond, LCConfig.COMMON.coinMintMeltableDiamond);
        LCRecipeProvider.GenerateMintAndMeltRecipes(consumer, ModItems.COIN_NETHERITE, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE, (ItemLike)Items.NETHERITE_INGOT, LCConfig.COMMON.coinMintMintableNetherite, LCConfig.COMMON.coinMintMeltableNetherite);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("nnn").pattern("ncn").pattern("nnn").define(Character.valueOf('c'), (ItemLike)ModItems.TRADING_CORE.get()).define(Character.valueOf('n'), Tags.Items.NUGGETS_IRON).save(consumer, LCRecipeProvider.ID("upgrades/create_template"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get()), (int)2).group("lightmans_template_copy").unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).unlockedBy("template", LCRecipeProvider.LazyTrigger((ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get())).pattern("nnn").pattern("ntn").pattern("nnn").define(Character.valueOf('t'), (ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get()).define(Character.valueOf('n'), Tags.Items.NUGGETS_IRON).save(consumer, LCRecipeProvider.ID("upgrades/copy_template"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get()), (int)10).group("lightmans_template_copy").unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).unlockedBy("template", LCRecipeProvider.LazyTrigger((ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get())).pattern("iii").pattern("iti").pattern("iii").define(Character.valueOf('t'), (ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get()).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).save(consumer, LCRecipeProvider.ID("upgrades/copy_template_bulk"));
        Ingredient TEMPLATE = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get()});
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((TagKey)Tags.Items.CHESTS_WOODEN), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.ITEM_CAPACITY_UPGRADE_1.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader", LCRecipeProvider.TraderKnowledge()).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.ITEM_CAPACITY_UPGRADE_1));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ITEM_CAPACITY_UPGRADE_1.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.ITEM_CAPACITY_UPGRADE_2.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader", LCRecipeProvider.TraderKnowledge()).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.ITEM_CAPACITY_UPGRADE_1)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.ITEM_CAPACITY_UPGRADE_2));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ITEM_CAPACITY_UPGRADE_2.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.ITEM_CAPACITY_UPGRADE_3.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader", LCRecipeProvider.TraderKnowledge()).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.ITEM_CAPACITY_UPGRADE_2)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.ITEM_CAPACITY_UPGRADE_3));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ITEM_CAPACITY_UPGRADE_3.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.ITEM_CAPACITY_UPGRADE_4.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader", LCRecipeProvider.TraderKnowledge()).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.ITEM_CAPACITY_UPGRADE_3)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.ITEM_CAPACITY_UPGRADE_4));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_EYE}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.NETWORK_UPGRADE.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader", LCRecipeProvider.TraderKnowledge()).unlocks("terminal", LCRecipeProvider.TerminalKnowledge()).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.NETWORK_UPGRADE));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.HOPPER}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.HOPPER_UPGRADE.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.HOPPER_UPGRADE));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.CLOCK}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.SPEED_UPGRADE_1.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).unlocks("coin_mint", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_MINT)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.SPEED_UPGRADE_1));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SPEED_UPGRADE_1.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.SPEED_UPGRADE_2.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).unlocks("coin_mint", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_MINT)).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.SPEED_UPGRADE_1)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.SPEED_UPGRADE_2));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SPEED_UPGRADE_2.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.SPEED_UPGRADE_3.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).unlocks("coin_mint", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_MINT)).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.SPEED_UPGRADE_2)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.SPEED_UPGRADE_3));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SPEED_UPGRADE_3.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.SPEED_UPGRADE_4.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).unlocks("coin_mint", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_MINT)).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.SPEED_UPGRADE_3)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.SPEED_UPGRADE_4));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SPEED_UPGRADE_4.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.SPEED_UPGRADE_5.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).unlocks("coin_mint", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_MINT)).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.SPEED_UPGRADE_4)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.SPEED_UPGRADE_5));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of(LCTags.Items.ATM), (Ingredient)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.COIN_CHEST_EXCHANGE_UPGRADE.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("coin_chest", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_CHEST)).save(consumer.withConditions(new ICondition[]{ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChestUpgradeExchange)}), LCRecipeProvider.ItemID("upgrades/", ModItems.COIN_CHEST_EXCHANGE_UPGRADE));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.COIN_CHEST_MAGNET_UPGRADE_1.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("coin_chest", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_CHEST)).save(consumer.withConditions(new ICondition[]{ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChestUpgradeMagnet)}), LCRecipeProvider.ItemID("upgrades/", ModItems.COIN_CHEST_MAGNET_UPGRADE_1));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COIN_CHEST_MAGNET_UPGRADE_1.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.COIN_CHEST_MAGNET_UPGRADE_2.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("coin_chest", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_CHEST)).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.COIN_CHEST_MAGNET_UPGRADE_1)).save(consumer.withConditions(new ICondition[]{ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChestUpgradeMagnet)}), LCRecipeProvider.ItemID("upgrades/", ModItems.COIN_CHEST_MAGNET_UPGRADE_2));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COIN_CHEST_MAGNET_UPGRADE_2.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.COIN_CHEST_MAGNET_UPGRADE_3.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("coin_chest", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_CHEST)).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.COIN_CHEST_MAGNET_UPGRADE_2)).save(consumer.withConditions(new ICondition[]{ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChestUpgradeMagnet)}), LCRecipeProvider.ItemID("upgrades/", ModItems.COIN_CHEST_MAGNET_UPGRADE_3));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COIN_CHEST_MAGNET_UPGRADE_3.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.COIN_CHEST_MAGNET_UPGRADE_4.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("coin_chest", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_CHEST)).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.COIN_CHEST_MAGNET_UPGRADE_3)).save(consumer.withConditions(new ICondition[]{ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChestUpgradeMagnet)}), LCRecipeProvider.ItemID("upgrades/", ModItems.COIN_CHEST_MAGNET_UPGRADE_4));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.OBSIDIAN}), (Ingredient)Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.COIN_CHEST_SECURITY_UPGRADE.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("coin_chest", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_CHEST)).save(consumer.withConditions(new ICondition[]{ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChestUpgradeSecurity)}), LCRecipeProvider.ItemID("upgrades/", ModItems.COIN_CHEST_SECURITY_UPGRADE));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SUS_JAR.get())).requires(LCTags.Items.COIN_JAR_NORMAL).requires((ItemLike)Items.SUSPICIOUS_STEW).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("jar", LCRecipeProvider.LazyTrigger(LCTags.Items.COIN_JAR_ALL)).save(consumer, LCRecipeProvider.ItemID("coin_jar/", ModBlocks.SUS_JAR));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.TAX_COLLECTOR.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("ghg").pattern("nxn").pattern("geg").define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('n'), Tags.Items.INGOTS_NETHERITE).define(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).define(Character.valueOf('h'), (ItemLike)Items.HOPPER).define(Character.valueOf('e'), Tags.Items.ENDER_PEARLS).save(consumer.withConditions(new ICondition[]{ConfigCraftingCondition.of(LCConfig.COMMON.canCraftTaxBlock)}), LCRecipeProvider.ItemID(ModBlocks.TAX_COLLECTOR));
        MasterTicketRecipeBuilder.of(LCTags.Items.TICKET_MATERIAL_PAPER).withResult(ModItems.TICKET_MASTER).unlockedBy("ticket_station", (Criterion)LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_STATION)).unlockedBy("tickets", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).save(consumer, LCRecipeProvider.ItemID("ticket_station/", ModItems.TICKET_MASTER));
        TicketRecipeBuilder.of(LCTags.Items.TICKET_MATERIAL_PAPER, (ItemLike)ModItems.TICKET.get()).withMasterTicket((ItemLike)ModItems.TICKET_MASTER.get()).unlockedBy("ticket_station", (Criterion)LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_STATION)).unlockedBy("tickets", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).save(consumer, LCRecipeProvider.ItemID("ticket_station/", ModItems.TICKET));
        TicketRecipeBuilder.of(LCTags.Items.TICKET_MATERIAL_PAPER, (ItemLike)ModItems.TICKET_PASS.get()).withMasterTicket((ItemLike)ModItems.TICKET_MASTER.get()).unlockedBy("ticket_station", (Criterion)LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_STATION)).unlockedBy("tickets", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).save(consumer, LCRecipeProvider.ItemID("ticket_station/", ModItems.TICKET_PASS));
        MasterTicketRecipeBuilder.of(LCTags.Items.TICKET_MATERIAL_GOLD).withResult(ModItems.GOLDEN_TICKET_MASTER).unlockedBy("ticket_station", (Criterion)LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_STATION)).unlockedBy("tickets", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).save(consumer, LCRecipeProvider.ItemID("ticket_station/", ModItems.GOLDEN_TICKET_MASTER));
        TicketRecipeBuilder.of(LCTags.Items.TICKET_MATERIAL_GOLD, (ItemLike)ModItems.GOLDEN_TICKET.get()).withMasterTicket((ItemLike)ModItems.GOLDEN_TICKET_MASTER.get()).unlockedBy("ticket_station", (Criterion)LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_STATION)).unlockedBy("tickets", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).save(consumer, LCRecipeProvider.ItemID("ticket_station/", ModItems.GOLDEN_TICKET));
        TicketRecipeBuilder.of(LCTags.Items.TICKET_MATERIAL_GOLD, (ItemLike)ModItems.GOLDEN_TICKET_PASS.get()).withMasterTicket((ItemLike)ModItems.GOLDEN_TICKET_MASTER.get()).unlockedBy("ticket_station", (Criterion)LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_STATION)).unlockedBy("tickets", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).save(consumer, LCRecipeProvider.ItemID("ticket_station/", ModItems.GOLDEN_TICKET_PASS));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TRADING_CORE.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.OFFER_UPGRADE_1.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader", LCRecipeProvider.TraderKnowledge()).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.OFFER_UPGRADE_1));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.OFFER_UPGRADE_1.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.OFFER_UPGRADE_2.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader", LCRecipeProvider.TraderKnowledge()).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.OFFER_UPGRADE_1)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.OFFER_UPGRADE_2));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.OFFER_UPGRADE_2.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.OFFER_UPGRADE_3.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader", LCRecipeProvider.TraderKnowledge()).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.OFFER_UPGRADE_2)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.OFFER_UPGRADE_3));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.OFFER_UPGRADE_3.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.OFFER_UPGRADE_4.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader", LCRecipeProvider.TraderKnowledge()).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.OFFER_UPGRADE_3)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.OFFER_UPGRADE_4));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.OFFER_UPGRADE_4.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.OFFER_UPGRADE_5.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader", LCRecipeProvider.TraderKnowledge()).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.OFFER_UPGRADE_4)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.OFFER_UPGRADE_5));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.OFFER_UPGRADE_5.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.OFFER_UPGRADE_6.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("trader", LCRecipeProvider.TraderKnowledge()).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.OFFER_UPGRADE_5)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.OFFER_UPGRADE_6));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of(LCTags.Items.ATM), (Ingredient)Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.COIN_CHEST_BANK_UPGRADE.get()).unlocks("money", LCRecipeProvider.MoneyKnowledge()).unlocks("coin_chest", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_CHEST)).unlocks("atm", LCRecipeProvider.LazyTrigger(LCTags.Items.ATM)).save(consumer.withConditions(new ICondition[]{ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChestUpgradeBank)}), LCRecipeProvider.ItemID("upgrades/", ModItems.COIN_CHEST_BANK_UPGRADE));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ATM_CARD.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("atm", LCRecipeProvider.LazyTrigger(LCTags.Items.ATM)).requires((ItemLike)Items.PAPER).requires(Tags.Items.ENDER_PEARLS).requires(Tags.Items.NUGGETS_IRON).save(consumer.withConditions(new ICondition[]{ConfigCraftingCondition.of(LCConfig.COMMON.canCraftATMCard)}), LCRecipeProvider.ItemID(ModItems.ATM_CARD));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.NETWORK_UPGRADE.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.INTERACTION_UPGRADE_1.get()).unlocks("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).unlocks("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).unlocks("network_trader", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_NETWORK)).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.NETWORK_UPGRADE)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.INTERACTION_UPGRADE_1));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.INTERACTION_UPGRADE_1.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.INTERACTION_UPGRADE_2.get()).unlocks("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).unlocks("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).unlocks("network_trader", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_NETWORK)).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.NETWORK_UPGRADE)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.INTERACTION_UPGRADE_2));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TEMPLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.INTERACTION_UPGRADE_2.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.INTERACTION_UPGRADE_3.get()).unlocks("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).unlocks("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).unlocks("network_trader", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_NETWORK)).unlocks("previous", LCRecipeProvider.LazyTrigger(ModItems.NETWORK_UPGRADE)).save(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.INTERACTION_UPGRADE_3));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.GACHA_MACHINE.get(Color.WHITE))).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("ggg").pattern("gxg").pattern("iii").define(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).save(consumer, LCRecipeProvider.ID("traders/gacha_machine"));
        LCRecipeProvider.GenerateColoredDyeAndWashRecipes(consumer, ModBlocks.GACHA_MACHINE, (ItemLike)ModBlocks.GACHA_MACHINE.get(Color.WHITE), "gacha_dyes", "traders/gacha_machine/", Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"money", LCRecipeProvider.MoneyKnowledge()), Pair.of((Object)"trader", LCRecipeProvider.TraderKnowledge())}));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.MONEY_BAG.get())).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("wallet", LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).pattern(" s ").pattern("lgl").pattern("lll").define(Character.valueOf('s'), Tags.Items.STRINGS).define(Character.valueOf('l'), Tags.Items.LEATHERS).define(Character.valueOf('g'), Tags.Items.NUGGETS_GOLD).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.VARIANT_WAND.get())).unlockedBy("trader", LCRecipeProvider.TraderKnowledge()).pattern("i i").pattern("ntn").pattern(" s ").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('n'), Tags.Items.NUGGETS_IRON).define(Character.valueOf('t'), (ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get()).define(Character.valueOf('s'), (ItemLike)Items.STICK).save(consumer);
    }

    private static void GenerateWalletRecipes(@Nonnull RecipeOutput consumer, List<Pair<Ingredient, Supplier<? extends ItemLike>>> ingredientWalletPairs) {
        int w;
        Ingredient leather = Ingredient.of((TagKey)Tags.Items.LEATHERS);
        List<Ingredient> ingredients = ingredientWalletPairs.stream().map(Pair::getFirst).toList();
        List<ItemLike> wallets = ingredientWalletPairs.stream().map(p -> (ItemLike)((Supplier)p.getSecond()).get()).toList();
        for (w = 0; w < wallets.size(); ++w) {
            ItemLike wallet = wallets.get(w);
            ShapelessRecipeBuilder b = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)wallet).group("wallet_crafting").unlockedBy("coin", LCRecipeProvider.MoneyKnowledge()).unlockedBy("wallet", LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).requires(leather);
            for (int i = 0; i < ingredients.size() && i <= w; ++i) {
                b.requires(ingredients.get(i));
            }
            b.requires(leather);
            b.save(consumer, LCRecipeProvider.ItemID("wallet/", wallet));
        }
        for (w = 0; w < wallets.size() - 1; ++w) {
            for (int w2 = w + 1; w2 < wallets.size(); ++w2) {
                ItemLike first = wallets.get(w);
                ItemLike result = wallets.get(w2);
                WalletUpgradeRecipeBuilder b = WalletUpgradeRecipeBuilder.shapeless(RecipeCategory.MISC, result).group("wallet_upgrading").unlockedBy("coin", (Criterion)LCRecipeProvider.MoneyKnowledge()).unlockedBy("wallet", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).requires(first);
                for (int i = w + 1; i < ingredients.size() && i <= w2; ++i) {
                    b.requires(ingredients.get(i));
                }
                b.save(consumer, LCRecipeProvider.ID("wallet/upgrade_" + LCRecipeProvider.ItemPath(first) + "_to_" + LCRecipeProvider.ItemPath(result)));
            }
        }
    }

    private static void GenerateLastWalletRecipeAndUpgrades(@Nonnull RecipeOutput consumer, List<Pair<Ingredient, Supplier<? extends ItemLike>>> ingredientWalletPairs) {
        Ingredient leather = Ingredient.of((TagKey)Tags.Items.LEATHERS);
        List<Ingredient> ingredients = ingredientWalletPairs.stream().map(Pair::getFirst).toList();
        List<ItemLike> wallets = ingredientWalletPairs.stream().map(p -> (ItemLike)((Supplier)p.getSecond()).get()).toList();
        ItemLike wallet = wallets.getLast();
        ShapelessRecipeBuilder b = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)wallet).group("wallet_crafting").unlockedBy("coin", LCRecipeProvider.MoneyKnowledge()).unlockedBy("wallet", LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).requires(leather);
        for (Ingredient ingredient : ingredients) {
            b.requires(ingredient);
        }
        b.requires(leather);
        b.save(consumer, LCRecipeProvider.ID("wallet/" + LCRecipeProvider.ItemPath(wallet)));
        for (int w = 0; w < wallets.size() - 1; ++w) {
            ItemLike first = wallets.get(w);
            ItemLike result = wallets.getLast();
            WalletUpgradeRecipeBuilder b2 = WalletUpgradeRecipeBuilder.shapeless(RecipeCategory.MISC, result).group("wallet_upgrading").unlockedBy("coin", (Criterion)LCRecipeProvider.MoneyKnowledge()).unlockedBy("wallet", (Criterion)LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).requires(first);
            for (int i = w + 1; i < ingredients.size(); ++i) {
                b2.requires(ingredients.get(i));
            }
            b2.save(consumer, LCRecipeProvider.ID("wallet/upgrade_" + LCRecipeProvider.ItemPath(first) + "_to_" + LCRecipeProvider.ItemPath(result)));
        }
    }

    private static void GenerateSwapRecipes(@Nonnull RecipeOutput consumer, ItemLike item1, ItemLike item2, List<Pair<String, Criterion<?>>> criteria) {
        String group = LCRecipeProvider.ItemPath(item2) + "_swap";
        LCRecipeProvider.GenerateSwapRecipe(consumer, item1, item2, group, criteria);
        LCRecipeProvider.GenerateSwapRecipe(consumer, item2, item1, group, criteria);
    }

    private static void GenerateSwapRecipe(@Nonnull RecipeOutput consumer, ItemLike item1, ItemLike item2, @Nullable String group, List<Pair<String, Criterion<?>>> criteria) {
        ShapelessRecipeBuilder b = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)item2).group(group);
        LCRecipeProvider.ApplyCriteria(b, criteria);
        b.unlockedBy("other", LCRecipeProvider.LazyTrigger(item1)).requires(item1).save(consumer, LCRecipeProvider.ID(LCRecipeProvider.ItemPath(item1) + "_swap"));
    }

    private static void GenerateCoinBlockRecipes(@Nonnull RecipeOutput consumer, Supplier<? extends ItemLike> coin, Supplier<? extends ItemLike> coinPile, Supplier<? extends ItemLike> coinBlock) {
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, coin, coinPile, coinBlock, "", LCRecipeProvider.MoneyKnowledge());
    }

    private static void GenerateCoinBlockRecipes(@Nonnull RecipeOutput consumer, Supplier<? extends ItemLike> coin, Supplier<? extends ItemLike> coinPile, Supplier<? extends ItemLike> coinBlock, @Nonnull String prefix, @Nonnull Criterion<?> moneyKnowledge) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)coinPile.get()).group(prefix + "coin_pile_from_coin").unlockedBy("money", moneyKnowledge).unlockedBy("coin", LCRecipeProvider.LazyTrigger(coin)).requires(coin.get(), 9).save(consumer, LCRecipeProvider.ID("coins/" + LCRecipeProvider.ItemPath(coinPile) + "_from_coin"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)coinBlock.get()).group(prefix + "coin_block_from_pile").unlockedBy("money", moneyKnowledge).unlockedBy("pile", LCRecipeProvider.LazyTrigger(coinPile)).pattern("xx").pattern("xx").define(Character.valueOf('x'), coinPile.get()).save(consumer, LCRecipeProvider.ID("coins/" + LCRecipeProvider.ItemPath(coinBlock) + "_from_pile"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)coinPile.get(), (int)4).group(prefix + "coin_pile_from_block").unlockedBy("money", moneyKnowledge).unlockedBy("block", LCRecipeProvider.LazyTrigger(coinBlock)).requires(coinBlock.get()).save(consumer, LCRecipeProvider.ID("coins/" + LCRecipeProvider.ItemPath(coinPile) + "_from_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)coin.get(), (int)9).group(prefix + "coin_from_pile").unlockedBy("money", moneyKnowledge).unlockedBy("pile", LCRecipeProvider.LazyTrigger(coinPile)).requires(coinPile.get()).save(consumer, LCRecipeProvider.ID("coins/" + LCRecipeProvider.ItemPath(coin) + "_from_pile"));
    }

    private static void GenerateColoredDyeAndWashRecipes(@Nonnull RecipeOutput consumer, RegistryObjectBundle<? extends ItemLike, Color> bundle, ItemLike cleanItem, @Nullable String dyeGroup, String prefix, List<Pair<String, Criterion<?>>> criteria) {
        ArrayList<ItemLike> coloredSet = new ArrayList<ItemLike>();
        for (Color color : Color.values()) {
            ItemLike result = bundle.get(color);
            if (result.asItem() == cleanItem.asItem()) continue;
            coloredSet.add(result);
            ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).group(dyeGroup).unlockedBy("cleanitem", LCRecipeProvider.LazyTrigger(cleanItem)).requires(cleanItem).requires(color.dyeTag);
            LCRecipeProvider.ApplyCriteria(builder, criteria);
            builder.save(consumer, LCRecipeProvider.ID(prefix + "dye_" + color.getResourceSafeName()));
        }
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)cleanItem);
        LCRecipeProvider.ApplyCriteria(builder, criteria);
        builder.unlockedBy("colored", LCRecipeProvider.LazyTrigger(coloredSet)).requires(Ingredient.of(coloredSet.stream().map(ItemStack::new))).requires((ItemLike)Items.WATER_BUCKET).save(consumer, LCRecipeProvider.ID(prefix + "washing"));
    }

    @Deprecated
    private static void GenerateMintAndMeltRecipes(@Nonnull RecipeOutput consumer, Supplier<? extends ItemLike> coin, TagKey<Item> materialTag, ItemLike materialItem) {
        LCRecipeProvider.GenerateMintAndMeltRecipes(consumer, coin, materialTag, materialItem, null, null);
    }

    private static void GenerateMintAndMeltRecipes(@Nonnull RecipeOutput consumer, Supplier<? extends ItemLike> coin, TagKey<Item> materialTag, ItemLike materialItem, @Nullable BooleanOption mintConfig, @Nullable BooleanOption meltConfig) {
        MintRecipeBuilder.create(materialTag, coin.get()).unlockedBy("money", (Criterion)LCRecipeProvider.MoneyKnowledge()).unlockedBy("coin_mint", (Criterion)LCRecipeProvider.LazyTrigger(ModBlocks.COIN_MINT)).save(consumer.withConditions(LCRecipeProvider.lazyArray(ConfigCraftingCondition.of(LCConfig.COMMON.coinMintCanMint), mintConfig != null ? ConfigCraftingCondition.of(mintConfig) : null)), LCRecipeProvider.ItemID("coin_mint/mint_", coin));
        MintRecipeBuilder.create(coin.get(), materialItem).unlockedBy("money", (Criterion)LCRecipeProvider.MoneyKnowledge()).unlockedBy("coin_mint", (Criterion)LCRecipeProvider.LazyTrigger(ModBlocks.COIN_MINT)).save(consumer.withConditions(LCRecipeProvider.lazyArray(ConfigCraftingCondition.of(LCConfig.COMMON.coinMintCanMelt), meltConfig != null ? ConfigCraftingCondition.of(meltConfig) : null)), LCRecipeProvider.ItemID("coin_mint/melt_", coin));
    }

    private static ICondition[] lazyArray(ICondition ... nullableInputs) {
        ArrayList<ICondition> list = new ArrayList<ICondition>();
        for (ICondition value : nullableInputs) {
            if (value == null) continue;
            list.add(value);
        }
        return (ICondition[])list.toArray(ICondition[]::new);
    }

    private static Criterion<?> MoneyKnowledge() {
        return LCRecipeProvider.LazyTrigger(LCTags.Items.COINS);
    }

    private static Criterion<?> TraderKnowledge() {
        return LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER);
    }

    private static Criterion<?> TerminalKnowledge() {
        return LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL);
    }

    private static Criterion<?> LazyTrigger(ItemLike item) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{item}).build()});
    }

    private static Criterion<?> LazyTrigger(List<? extends ItemLike> items) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(items.toArray(new ItemLike[0])).build()});
    }

    private static Criterion<?> LazyTrigger(Supplier<? extends ItemLike> item) {
        return LCRecipeProvider.LazyTrigger(item.get());
    }

    private static Criterion<?> LazyTrigger(TagKey<Item> tag) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(tag).build()});
    }

    private static void ApplyCriteria(ShapelessRecipeBuilder builder, List<Pair<String, Criterion<?>>> criteria) {
        for (Pair<String, Criterion<?>> c : criteria) {
            builder.unlockedBy((String)c.getFirst(), (Criterion)c.getSecond());
        }
    }

    private static String ItemPath(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
    }

    private static String ItemPath(Supplier<? extends ItemLike> item) {
        return LCRecipeProvider.ItemPath(item.get());
    }

    private static ResourceLocation ItemID(String prefix, ItemLike item) {
        return LCRecipeProvider.ID(prefix + LCRecipeProvider.ItemPath(item));
    }

    private static ResourceLocation ItemID(Supplier<? extends ItemLike> item) {
        return LCRecipeProvider.ID(LCRecipeProvider.ItemPath(item));
    }

    private static ResourceLocation ItemID(String prefix, Supplier<? extends ItemLike> item) {
        return LCRecipeProvider.ID(prefix + LCRecipeProvider.ItemPath(item));
    }

    private static ResourceLocation WoodID(String prefix, WoodType woodType) {
        return LCRecipeProvider.ID(woodType.generateResourceLocation(prefix));
    }

    private static ResourceLocation WoodID(String prefix, WoodType woodType, String postfix) {
        return LCRecipeProvider.ID(woodType.generateResourceLocation(prefix, postfix));
    }

    private static ResourceLocation ColoredWoodID(String prefix, WoodType woodType, Color color) {
        return LCRecipeProvider.WoodID(prefix, woodType, "/" + color.getResourceSafeName());
    }

    private static ResourceLocation ID(String path) {
        return VersionUtil.lcResource(path);
    }
}

