/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lightman314.lightmanscurrency.api.codecs.LCCodecs;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class BankUpgradeData {
    public static final BankUpgradeData DEFAULT = new BankUpgradeData(true, MoneyValue.empty(), Optional.empty(), Optional.empty(), (List<ItemStack>)ImmutableList.of());
    public static final Codec<BankUpgradeData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("deposit").forGetter(d -> d.depositMode), (App)LCCodecs.MONEY_VALUE.fieldOf("moneyLimit").forGetter(d -> d.moneyLimit), (App)LCCodecs.PLAYER_REFERENCE.optionalFieldOf("player").forGetter(d -> Optional.ofNullable(d.player)), (App)LCCodecs.BANK_REFERENCE.optionalFieldOf("account").forGetter(d -> Optional.ofNullable(d.targetAccount)), (App)ItemStack.CODEC.listOf().fieldOf("overflowItems").forGetter(d -> d.overflowItems)).apply((Applicative)builder, BankUpgradeData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BankUpgradeData> STREAM_CODEC = StreamCodec.of((b, d) -> {
        b.writeBoolean(d.depositMode);
        d.moneyLimit.encode((FriendlyByteBuf)b);
        if (d.targetAccount == null) {
            b.writeBoolean(false);
        } else {
            b.writeBoolean(true);
            b.writeNbt((Tag)d.player.save());
            d.targetAccount.encode((FriendlyByteBuf)b);
        }
        b.writeInt(d.overflowItems.size());
        for (ItemStack i : d.overflowItems) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode(b, (Object)i);
        }
    }, b -> {
        boolean dm = b.readBoolean();
        MoneyValue val = MoneyValue.decode((FriendlyByteBuf)b);
        BankReference tba = null;
        PlayerReference p = null;
        if (b.readBoolean()) {
            p = PlayerReference.load(b.readNbt());
            tba = BankReference.decode((FriendlyByteBuf)b);
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int count = b.readInt();
        for (int i = 0; i < count; ++i) {
            ItemStack item = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode(b);
            if (item.isEmpty()) continue;
            list.add(item);
        }
        return new BankUpgradeData(dm, val, p, tba, (List<ItemStack>)ImmutableList.copyOf(list));
    });
    public final boolean depositMode;
    @Nonnull
    public final MoneyValue moneyLimit;
    @Nullable
    public final PlayerReference player;
    @Nullable
    public final BankReference targetAccount;
    @Nonnull
    private final List<ItemStack> overflowItems;

    public List<ItemStack> getOverflowItems() {
        return InventoryUtil.copyList(this.overflowItems);
    }

    public boolean canInteract() {
        return this.targetAccount != null && this.player != null && this.overflowItems.isEmpty();
    }

    private BankUpgradeData(boolean depositMode, @Nonnull MoneyValue moneyLimit, @Nonnull Optional<PlayerReference> player, @Nonnull Optional<BankReference> targetAccount, @Nonnull List<ItemStack> overflowItems) {
        this(depositMode, moneyLimit, (PlayerReference)player.orElse(null), (BankReference)targetAccount.orElse(null), overflowItems);
    }

    public BankUpgradeData(boolean depositMode, @Nonnull MoneyValue moneyLimit, @Nullable PlayerReference player, @Nullable BankReference targetAccount, @Nonnull List<ItemStack> overflowItems) {
        this.depositMode = depositMode;
        this.moneyLimit = Objects.requireNonNullElse(moneyLimit, MoneyValue.empty());
        this.player = player;
        this.targetAccount = targetAccount;
        this.overflowItems = overflowItems;
    }

    @Nonnull
    public BankUpgradeData setDepositMode(boolean depositMode) {
        return new BankUpgradeData(depositMode, this.moneyLimit, this.player, this.targetAccount, this.overflowItems);
    }

    @Nonnull
    public BankUpgradeData setMoneyLimit(@Nonnull MoneyValue moneyLimit) {
        return new BankUpgradeData(this.depositMode, moneyLimit, this.player, this.targetAccount, this.overflowItems);
    }

    @Nonnull
    public BankUpgradeData setBankAccount(@Nonnull PlayerReference player, @Nonnull BankReference targetAccount) {
        return new BankUpgradeData(this.depositMode, this.moneyLimit, player, targetAccount, this.overflowItems);
    }

    @Nonnull
    public BankUpgradeData setOverflowItems(@Nonnull List<ItemStack> overflowItems) {
        return new BankUpgradeData(this.depositMode, this.moneyLimit, this.player, this.targetAccount, InventoryUtil.copyList(overflowItems));
    }

    public int hashCode() {
        return Objects.hash(this.depositMode, this.moneyLimit, this.player, this.targetAccount);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BankUpgradeData) {
            BankUpgradeData other = (BankUpgradeData)obj;
            return other.depositMode == this.depositMode && other.moneyLimit.equals(this.moneyLimit) && Objects.equals(this.player, other.player) && Objects.equals(this.targetAccount, other.targetAccount) && this.overflowItems.equals(other.overflowItems);
        }
        return false;
    }
}

