/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.categories;

import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategoryType;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class TraderCategory
extends NotificationCategory {
    public static final NotificationCategoryType<TraderCategory> TYPE = new NotificationCategoryType<TraderCategory>(VersionUtil.lcResource("trader"), TraderCategory::new);
    private final Item trader;
    private final long traderID;
    private final MutableComponent traderName;

    public TraderCategory(ItemLike trader, MutableComponent traderName, long traderID) {
        this.trader = trader.asItem();
        this.traderName = traderName;
        this.traderID = traderID;
    }

    public TraderCategory(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        this.trader = compound.contains("Icon") ? (Item)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(compound.getString("Icon"))) : ModItems.TRADING_CORE.get();
        this.traderName = compound.contains("TraderName") ? Component.Serializer.fromJson((String)compound.getString("TraderName"), (HolderLookup.Provider)lookup) : Component.translatable((String)"gui.lightmanscurrency.universaltrader.default");
        this.traderID = compound.contains("TraderID") ? compound.getLong("TraderID") : -1L;
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)this.trader);
    }

    @Override
    @Nonnull
    public MutableComponent getName() {
        return this.traderName;
    }

    @Nonnull
    public NotificationCategoryType<TraderCategory> getType() {
        return TYPE;
    }

    @Override
    public boolean matches(NotificationCategory other) {
        if (other instanceof TraderCategory) {
            TraderCategory otherTrader = (TraderCategory)other;
            if (this.traderID >= 0L && this.traderID == otherTrader.traderID) {
                return true;
            }
            return this.traderName.getString().contentEquals(otherTrader.traderName.getString()) && this.trader.equals(otherTrader.trader);
        }
        return false;
    }

    @Override
    public void saveAdditional(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        compound.putString("Icon", BuiltInRegistries.ITEM.getKey((Object)this.trader).toString());
        compound.putString("TraderName", Component.Serializer.toJson((Component)this.traderName, (HolderLookup.Provider)lookup));
        compound.putLong("TraderID", this.traderID);
    }
}

