/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.core.TaxInfoClientTab;
import io.github.lightman314.lightmanscurrency.common.data.types.TaxDataCache;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;

public class TaxInfoTab
extends TraderStorageTab {
    public TaxInfoTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    public Object createClientTab(@Nonnull Object screen) {
        return new TaxInfoClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return ((ITraderStorageMenu)this.menu).hasPermission("editSettings");
    }

    public void AcceptTaxes(long taxCollector) {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        if (trader != null && trader.hasPermission(((ITraderStorageMenu)this.menu).getPlayer(), "editSettings")) {
            TaxEntry entry = TaxDataCache.TYPE.get(this).getEntry(taxCollector);
            if (entry != null && entry.IsInArea(trader)) {
                entry.AcceptTaxable(trader);
            }
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setLong("AcceptTaxCollector", taxCollector));
            }
        }
    }

    public void ForceIgnoreTaxCollector(long taxCollector) {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        if (trader != null) {
            TaxEntry entry = TaxDataCache.TYPE.get(this).getEntry(taxCollector);
            if (entry != null && entry.IsInArea(trader)) {
                trader.FlagTaxEntryToIgnore(entry, ((ITraderStorageMenu)this.menu).getPlayer());
            }
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setLong("ForceIgnoreTaxCollector", taxCollector));
            }
        }
    }

    public void PardonIgnoredTaxCollector(long taxCollector) {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        if (trader != null && trader.hasPermission(((ITraderStorageMenu)this.menu).getPlayer(), "editSettings")) {
            TaxEntry entry = TaxDataCache.TYPE.get(this).getEntry(taxCollector);
            if (entry != null && entry.IsInArea(trader)) {
                trader.PardonTaxEntry(entry);
            }
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setLong("PardonTaxCollector", taxCollector));
            }
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("AcceptTaxCollector")) {
            this.AcceptTaxes(message.getLong("AcceptTaxCollector"));
        }
        if (message.contains("ForceIgnoreTaxCollector")) {
            this.ForceIgnoreTaxCollector(message.getLong("ForceIgnoreTaxCollector"));
        }
        if (message.contains("PardonTaxCollector")) {
            this.PardonIgnoredTaxCollector(message.getLong("PardonTaxCollector"));
        }
    }
}

