/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.enchantments;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.common.util.LookupHelper;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class CoinMagnetEnchantment {
    public static void runEntityTick(@Nonnull WalletHandler walletHandler, @Nonnull LivingEntity entity) {
        int enchantLevel;
        if (entity.isSpectator()) {
            return;
        }
        ItemStack wallet = walletHandler.getWallet();
        if (!WalletItem.isWallet(wallet) || !WalletItem.CanPickup((WalletItem)wallet.getItem())) {
            return;
        }
        Holder<Enchantment> cmEnchant = LookupHelper.lookupEnchantment((HolderLookup.Provider)entity.registryAccess(), ModEnchantments.COIN_MAGNET);
        int n = enchantLevel = cmEnchant != null ? wallet.getEnchantmentLevel(cmEnchant) : 0;
        if (enchantLevel <= 0) {
            return;
        }
        float range = CoinMagnetEnchantment.getCollectionRange(enchantLevel);
        Level level = entity.level();
        AABB searchBox = new AABB(entity.xo - (double)range, entity.yo - (double)range, entity.zo - (double)range, entity.xo + (double)range, entity.yo + (double)range, entity.zo + (double)range);
        boolean updateWallet = false;
        for (Entity e2 : level.getEntities((Entity)entity, searchBox, e -> CoinMagnetEnchantment.coinMagnetEntityFilter(e, entity))) {
            ItemEntity ie = (ItemEntity)e2;
            ItemStack coinStack = ie.getItem();
            ItemStack leftovers = WalletItem.PickupCoin(wallet, coinStack);
            if (InventoryUtil.ItemsFullyMatch(leftovers, coinStack)) continue;
            updateWallet = true;
            if (leftovers.isEmpty()) {
                ie.discard();
            } else {
                ie.setItem(leftovers);
            }
            WalletItem.playCollectSound(entity, wallet);
        }
        if (updateWallet) {
            walletHandler.setWallet(wallet);
            WalletMenuBase.OnWalletUpdated((Entity)entity);
        }
    }

    public static boolean coinMagnetEntityFilter(Entity entity, @Nonnull LivingEntity potentialPickup) {
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            if (item.getTarget() != null && !item.getTarget().equals(potentialPickup.getUUID())) {
                return false;
            }
            return CoinAPI.API.IsAllowedInCoinContainer(item.getItem(), false);
        }
        return false;
    }

    public static float getCollectionRange(int enchantLevel) {
        if (--enchantLevel < 0) {
            return 0.0f;
        }
        return (Integer)LCConfig.SERVER.coinMagnetBaseRange.get() + (Integer)LCConfig.SERVER.coinMagnetLeveledRange.get() * Math.min(enchantLevel, (Integer)LCConfig.SERVER.coinMagnetCalculationCap.get());
    }

    public static Component getCollectionRangeDisplay(int enchantLevel) {
        float range = CoinMagnetEnchantment.getCollectionRange(enchantLevel);
        String display = range % 1.0f > 0.0f ? String.valueOf(range) : String.valueOf(Math.round(range));
        return Component.literal((String)display).withStyle(ChatFormatting.GREEN);
    }

    public static void addWalletTooltips(List<Component> tooltips, int enchantLevel, ItemStack wallet) {
        if (wallet.getItem() instanceof WalletItem && enchantLevel > 0 && WalletItem.CanPickup((WalletItem)wallet.getItem())) {
            tooltips.add((Component)LCText.TOOLTIP_WALLET_PICKUP_MAGNET.get(CoinMagnetEnchantment.getCollectionRangeDisplay(enchantLevel)).withStyle(ChatFormatting.YELLOW));
        }
    }
}

