/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.core;

import io.github.lightman314.lightmanscurrency.common.blocks.ATMBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CashRegisterBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinChestBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinJarBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinMintBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinpileBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.MoneyBagBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.TaxCollectorBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.TerminalBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.TicketStationBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.tradeinterface.ItemTraderInterfaceBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.ArmorDisplayBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.BookTraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.CardDisplayBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.CommandTraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.DisplayCaseBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.FreezerBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.GachaMachineBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.NetworkItemTraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.ShelfBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.SlotMachineBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.TicketKioskBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.VendingMachineBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.VendingMachineLargeBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.reference.AuctionStandBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModRegistries;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBiBundle;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.common.items.CashRegisterItem;
import io.github.lightman314.lightmanscurrency.common.items.CoinJarItem;
import io.github.lightman314.lightmanscurrency.common.items.MoneyBagItem;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ModBlocks {
    private static final SoundType CHOCOLATE_SOUND = SoundType.MUD_BRICKS;
    public static final Supplier<Block> COINPILE_COPPER = ModBlocks.register("coinpile_copper", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(3.0f, 6.0f).sound(SoundType.METAL)));
    public static final Supplier<Block> COINPILE_IRON = ModBlocks.register("coinpile_iron", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 6.0f).sound(SoundType.METAL)));
    public static final Supplier<Block> COINPILE_GOLD = ModBlocks.register("coinpile_gold", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).strength(3.0f, 6.0f).sound(SoundType.METAL)));
    public static final Supplier<Block> COINPILE_DIAMOND;
    public static final Supplier<Block> COINPILE_EMERALD;
    public static final Supplier<Block> COINPILE_NETHERITE;
    public static final Supplier<Block> COINPILE_CHOCOLATE_COPPER;
    public static final Supplier<Block> COINPILE_CHOCOLATE_IRON;
    public static final Supplier<Block> COINPILE_CHOCOLATE_GOLD;
    public static final Supplier<Block> COINPILE_CHOCOLATE_DIAMOND;
    public static final Supplier<Block> COINPILE_CHOCOLATE_EMERALD;
    public static final Supplier<Block> COINPILE_CHOCOLATE_NETHERITE;
    public static final Supplier<Block> COINBLOCK_COPPER;
    public static final Supplier<Block> COINBLOCK_IRON;
    public static final Supplier<Block> COINBLOCK_GOLD;
    public static final Supplier<Block> COINBLOCK_EMERALD;
    public static final Supplier<Block> COINBLOCK_DIAMOND;
    public static final Supplier<Block> COINBLOCK_NETHERITE;
    public static final Supplier<Block> COINBLOCK_CHOCOLATE_COPPER;
    public static final Supplier<Block> COINBLOCK_CHOCOLATE_IRON;
    public static final Supplier<Block> COINBLOCK_CHOCOLATE_GOLD;
    public static final Supplier<Block> COINBLOCK_CHOCOLATE_EMERALD;
    public static final Supplier<Block> COINBLOCK_CHOCOLATE_DIAMOND;
    public static final Supplier<Block> COINBLOCK_CHOCOLATE_NETHERITE;
    public static final Supplier<Block> ATM;
    public static final Supplier<Block> COIN_MINT;
    public static final RegistryObjectBundle<Block, Color> DISPLAY_CASE;
    public static final RegistryObjectBundle<Block, Color> VENDING_MACHINE;
    public static final RegistryObjectBundle<Block, Color> VENDING_MACHINE_LARGE;
    public static final RegistryObjectBundle<Block, WoodType> SHELF;
    public static final RegistryObjectBundle<Block, WoodType> SHELF_2x2;
    public static final RegistryObjectBiBundle<Block, WoodType, Color> CARD_DISPLAY;
    public static final Supplier<Block> ARMOR_DISPLAY;
    public static final RegistryObjectBundle<FreezerBlock, Color> FREEZER;
    public static final Supplier<Block> ITEM_NETWORK_TRADER_1;
    public static final Supplier<Block> ITEM_NETWORK_TRADER_2;
    public static final Supplier<Block> ITEM_NETWORK_TRADER_3;
    public static final Supplier<Block> ITEM_NETWORK_TRADER_4;
    public static final Supplier<Block> ITEM_TRADER_INTERFACE;
    public static final Supplier<Block> CASH_REGISTER;
    public static final Supplier<Block> TERMINAL;
    public static final Supplier<Block> GEM_TERMINAL;
    public static final Supplier<Block> PAYGATE;
    public static final Supplier<Block> TICKET_KIOSK;
    public static final RegistryObjectBundle<Block, WoodType> BOOKSHELF_TRADER;
    public static final Supplier<Block> SLOT_MACHINE;
    public static final RegistryObjectBundle<Block, Color> GACHA_MACHINE;
    public static final Supplier<Block> COMMAND_TRADER;
    public static final Supplier<Block> TICKET_STATION;
    public static final Supplier<Block> COIN_CHEST;
    public static final Supplier<Block> TAX_COLLECTOR;
    public static final Supplier<Block> MONEY_BAG;
    public static final Supplier<Block> PIGGY_BANK;
    public static final Supplier<Block> COINJAR_BLUE;
    public static final Supplier<Block> SUS_JAR;
    public static final RegistryObjectBundle<Block, WoodType> AUCTION_STAND;

    public static void init() {
    }

    private static <T extends Block> ResourceLocation idGetter(T block) {
        return BuiltInRegistries.BLOCK.getKey(block);
    }

    private static Function<Block, Item> getDefaultGenerator() {
        return block -> new BlockItem(block, new Item.Properties());
    }

    private static Function<Block, Item> getCoinGenerator(boolean fireResistant) {
        return block -> {
            Item.Properties properties = new Item.Properties();
            if (fireResistant) {
                properties.fireResistant();
            }
            return new BlockItem(block, properties);
        };
    }

    private static Function<Block, Item> getCoinJarGenerator() {
        return block -> new CoinJarItem((Block)block, new Item.Properties());
    }

    private static Function<Block, Item> getMoneyBagGenerator() {
        return block -> new MoneyBagItem((Block)block, new Item.Properties());
    }

    private static <T extends Block> Supplier<T> register(String name, Supplier<T> sup) {
        return ModBlocks.register(name, ModBlocks.getDefaultGenerator(), sup);
    }

    private static <T extends Block> Supplier<T> register(String name, Function<Block, Item> itemGenerator, Supplier<T> sup) {
        DeferredHolder block = ModRegistries.BLOCKS.register(name, sup);
        if (block != null) {
            ModRegistries.ITEMS.register(name, () -> ModBlocks.lambda$register$61(itemGenerator, (Supplier)block));
        }
        return block;
    }

    private static <T extends Block> RegistryObjectBundle<T, Color> registerColored(String name, Function<Color, T> block) {
        return ModBlocks.registerColored(name, block, null);
    }

    private static <T extends Block> RegistryObjectBundle<T, Color> registerColored(String name, Function<Color, T> block, @Nullable Color dontNameThisColor) {
        return ModBlocks.registerColored(name, ModBlocks.getDefaultGenerator(), block, dontNameThisColor);
    }

    private static <T extends Block> RegistryObjectBundle<T, Color> registerColored(String name, Function<Block, Item> itemGenerator, Function<Color, T> block, @Nullable Color dontNameThisColor) {
        RegistryObjectBundle<Block, Color> bundle = new RegistryObjectBundle<Block, Color>(Color::sortByColor);
        for (Color color : Color.values()) {
            Object thisName = name;
            if (color != dontNameThisColor) {
                thisName = (String)thisName + "_" + color.getResourceSafeName();
            }
            bundle.put(color, ModBlocks.register((String)thisName, itemGenerator, () -> (Block)block.apply(color)));
        }
        return bundle.lock();
    }

    private static <T extends Block> RegistryObjectBundle<T, WoodType> registerWooden(String name, Predicate<WoodType.Attributes> check, Function<WoodType, T> block) {
        return ModBlocks.registerWooden(name, check, ModBlocks.getDefaultGenerator(), block);
    }

    private static <T extends Block> RegistryObjectBundle<T, WoodType> registerWooden(String name, Predicate<WoodType.Attributes> check, Function<Block, Item> itemGenerator, Function<WoodType, T> block) {
        RegistryObjectBundle<Block, WoodType> bundle = new RegistryObjectBundle<Block, WoodType>(WoodType::sortByWood);
        for (WoodType woodType : WoodType.validValues()) {
            if (!check.test(woodType.attributes)) continue;
            String thisName = woodType.generateID(name);
            bundle.put(woodType, ModBlocks.register(thisName, itemGenerator, () -> (Block)block.apply(woodType)));
        }
        return bundle.lock();
    }

    private static <T extends Block> RegistryObjectBiBundle<T, WoodType, Color> registerWoodenAndColored(String name, Predicate<WoodType.Attributes> check, BiFunction<WoodType, Color, T> block) {
        return ModBlocks.registerWoodenAndColored(name, check, block, null);
    }

    private static <T extends Block> RegistryObjectBiBundle<T, WoodType, Color> registerWoodenAndColored(String name, Predicate<WoodType.Attributes> check, BiFunction<WoodType, Color, T> block, @Nullable Color ignoreColor) {
        return ModBlocks.registerWoodenAndColored(name, check, ModBlocks.getDefaultGenerator(), block, ignoreColor);
    }

    private static <T extends Block> RegistryObjectBiBundle<T, WoodType, Color> registerWoodenAndColored(String name, Predicate<WoodType.Attributes> check, Function<Block, Item> itemGenerator, BiFunction<WoodType, Color, T> block) {
        return ModBlocks.registerWoodenAndColored(name, check, itemGenerator, block, null);
    }

    private static <T extends Block> RegistryObjectBiBundle<T, WoodType, Color> registerWoodenAndColored(String name, Predicate<WoodType.Attributes> check, Function<Block, Item> itemGenerator, BiFunction<WoodType, Color, T> block, @Nullable Color ignoreColor) {
        RegistryObjectBiBundle<Block, WoodType, Color> bundle = new RegistryObjectBiBundle<Block, WoodType, Color>(WoodType::sortByWood, Color::sortByColor);
        for (WoodType woodType : WoodType.validValues()) {
            if (!check.test(woodType.attributes)) continue;
            for (Color color : Color.values()) {
                Object thisName = color == ignoreColor ? woodType.generateID(name) : woodType.generateID(name) + "_" + color.getResourceSafeName();
                bundle.put(woodType, color, ModBlocks.register((String)thisName, itemGenerator, () -> (Block)block.apply(woodType, color)));
            }
        }
        return bundle.lock();
    }

    private static /* synthetic */ Item lambda$register$61(Function itemGenerator, Supplier block) {
        return (Item)itemGenerator.apply((Block)block.get());
    }

    static {
        COINPILE_EMERALD = ModBlocks.register("coinpile_emerald", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.of().mapColor(MapColor.EMERALD).strength(3.0f, 6.0f).sound(SoundType.METAL)));
        COINPILE_DIAMOND = ModBlocks.register("coinpile_diamond", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).strength(3.0f, 6.0f).sound(SoundType.METAL)));
        COINPILE_NETHERITE = ModBlocks.register("coinpile_netherite", ModBlocks.getCoinGenerator(true), () -> new CoinpileBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 6.0f).sound(SoundType.METAL)));
        COINPILE_CHOCOLATE_COPPER = ModBlocks.register("coinpile_chocolate_copper", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(3.0f, 6.0f).sound(SoundType.MUD)));
        COINPILE_CHOCOLATE_IRON = ModBlocks.register("coinpile_chocolate_iron", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 6.0f).sound(CHOCOLATE_SOUND)));
        COINPILE_CHOCOLATE_GOLD = ModBlocks.register("coinpile_chocolate_gold", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).strength(3.0f, 6.0f).sound(CHOCOLATE_SOUND)));
        COINPILE_CHOCOLATE_EMERALD = ModBlocks.register("coinpile_chocolate_emerald", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.of().mapColor(MapColor.EMERALD).strength(3.0f, 6.0f).sound(CHOCOLATE_SOUND)));
        COINPILE_CHOCOLATE_DIAMOND = ModBlocks.register("coinpile_chocolate_diamond", ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).strength(3.0f, 6.0f).sound(CHOCOLATE_SOUND)));
        COINPILE_CHOCOLATE_NETHERITE = ModBlocks.register("coinpile_chocolate_netherite", ModBlocks.getCoinGenerator(true), () -> new CoinpileBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 6.0f).sound(CHOCOLATE_SOUND)));
        COINBLOCK_COPPER = ModBlocks.register("coinblock_copper", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(3.0f, 6.0f).sound(SoundType.METAL)));
        COINBLOCK_IRON = ModBlocks.register("coinblock_iron", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 6.0f).sound(SoundType.METAL)));
        COINBLOCK_GOLD = ModBlocks.register("coinblock_gold", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).strength(3.0f, 6.0f).sound(SoundType.METAL)));
        COINBLOCK_EMERALD = ModBlocks.register("coinblock_emerald", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.of().mapColor(MapColor.EMERALD).strength(3.0f, 6.0f).sound(SoundType.METAL)));
        COINBLOCK_DIAMOND = ModBlocks.register("coinblock_diamond", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).strength(3.0f, 6.0f).sound(SoundType.METAL)));
        COINBLOCK_NETHERITE = ModBlocks.register("coinblock_netherite", ModBlocks.getCoinGenerator(true), () -> new CoinBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 6.0f).sound(SoundType.METAL)));
        COINBLOCK_CHOCOLATE_COPPER = ModBlocks.register("coinblock_chocolate_copper", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(3.0f, 6.0f).sound(CHOCOLATE_SOUND)));
        COINBLOCK_CHOCOLATE_IRON = ModBlocks.register("coinblock_chocolate_iron", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 6.0f).sound(CHOCOLATE_SOUND)));
        COINBLOCK_CHOCOLATE_GOLD = ModBlocks.register("coinblock_chocolate_gold", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).strength(3.0f, 6.0f).sound(CHOCOLATE_SOUND)));
        COINBLOCK_CHOCOLATE_EMERALD = ModBlocks.register("coinblock_chocolate_emerald", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.of().mapColor(MapColor.EMERALD).strength(3.0f, 6.0f).sound(CHOCOLATE_SOUND)));
        COINBLOCK_CHOCOLATE_DIAMOND = ModBlocks.register("coinblock_chocolate_diamond", ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).strength(3.0f, 6.0f).sound(CHOCOLATE_SOUND)));
        COINBLOCK_CHOCOLATE_NETHERITE = ModBlocks.register("coinblock_chocolate_netherite", ModBlocks.getCoinGenerator(true), () -> new CoinBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 6.0f).sound(CHOCOLATE_SOUND)));
        ATM = ModBlocks.register("atm", () -> new ATMBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).strength(3.0f, 6.0f).sound(SoundType.METAL)));
        COIN_MINT = ModBlocks.register("coinmint", () -> new CoinMintBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).strength(2.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL)));
        CASH_REGISTER = ModBlocks.register("cash_register", block -> new CashRegisterItem((Block)block, new Item.Properties()), () -> new CashRegisterBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).strength(3.0f, 6.0f).sound(SoundType.METAL), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0)));
        DISPLAY_CASE = ModBlocks.registerColored("display_case", c -> new DisplayCaseBlock(BlockBehaviour.Properties.of().strength(2.0f, Float.POSITIVE_INFINITY).sound(SoundType.GLASS), (Color)((Object)c)), Color.WHITE);
        VENDING_MACHINE = ModBlocks.registerColored("vending_machine", c -> new VendingMachineBlock(BlockBehaviour.Properties.of().mapColor(c.mapColor).strength(5.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL)), Color.WHITE);
        VENDING_MACHINE_LARGE = ModBlocks.registerColored("vending_machine_large", c -> new VendingMachineLargeBlock(BlockBehaviour.Properties.of().mapColor(c.mapColor).strength(5.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL)), Color.WHITE);
        SHELF = ModBlocks.registerWooden("shelf", WoodType.Attributes.needsSlab, w -> new ShelfBlock(BlockBehaviour.Properties.of().mapColor(w.mapColor).strength(2.0f, Float.POSITIVE_INFINITY)));
        SHELF_2x2 = ModBlocks.registerWooden("shelf_2x2", WoodType.Attributes.needsSlab, w -> new ShelfBlock(BlockBehaviour.Properties.of().mapColor(w.mapColor).strength(2.0f, Float.POSITIVE_INFINITY), 4));
        CARD_DISPLAY = ModBlocks.registerWoodenAndColored("card_display", WoodType.Attributes.needsLog, (WoodType w, Color c) -> new CardDisplayBlock(BlockBehaviour.Properties.of().mapColor(w.mapColor).strength(2.0f, Float.POSITIVE_INFINITY).sound(SoundType.WOOD), w.generateID("block.lightmanscurrency.card_display"), (Color)((Object)c)), Color.RED);
        FREEZER = ModBlocks.registerColored("freezer", c -> new FreezerBlock(BlockBehaviour.Properties.of().mapColor(c.mapColor).strength(5.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL), FreezerBlock.GenerateDoorModel(c)), Color.BLACK);
        ARMOR_DISPLAY = ModBlocks.register("armor_display", () -> new ArmorDisplayBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL)));
        TICKET_KIOSK = ModBlocks.register("ticket_kiosk", () -> new TicketKioskBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL)));
        BOOKSHELF_TRADER = ModBlocks.registerWooden("bookshelf_trader", WoodType.Attributes.needsPlanksAndSlab, w -> new BookTraderBlock(BlockBehaviour.Properties.of().mapColor(w.mapColor).strength(3.0f, Float.POSITIVE_INFINITY).sound(SoundType.WOOD)));
        SLOT_MACHINE = ModBlocks.register("slot_machine", () -> new SlotMachineBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(3.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL)));
        GACHA_MACHINE = ModBlocks.registerColored("gacha_machine", c -> new GachaMachineBlock(BlockBehaviour.Properties.of().mapColor(c.mapColor).strength(3.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL), (Color)((Object)c)));
        ITEM_NETWORK_TRADER_1 = ModBlocks.register("item_trader_server_sml", () -> new NetworkItemTraderBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL), 4));
        ITEM_NETWORK_TRADER_2 = ModBlocks.register("item_trader_server_med", () -> new NetworkItemTraderBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL), 8));
        ITEM_NETWORK_TRADER_3 = ModBlocks.register("item_trader_server_lrg", () -> new NetworkItemTraderBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL), 12));
        ITEM_NETWORK_TRADER_4 = ModBlocks.register("item_trader_server_xlrg", () -> new NetworkItemTraderBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL), 16));
        ITEM_TRADER_INTERFACE = ModBlocks.register("item_trader_interface", () -> new ItemTraderInterfaceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL)));
        TERMINAL = ModBlocks.register("terminal", () -> new TerminalBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 6.0f).sound(SoundType.METAL), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)));
        GEM_TERMINAL = ModBlocks.register("gem_terminal", () -> new TerminalBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(3.0f, 6.0f).sound(SoundType.AMETHYST_CLUSTER), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0)));
        PAYGATE = ModBlocks.register("paygate", () -> new PaygateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL)));
        COMMAND_TRADER = ModBlocks.register("command_trader", () -> new CommandTraderBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL)));
        TICKET_STATION = ModBlocks.register("ticket_machine", () -> new TicketStationBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 6.0f).sound(SoundType.METAL)));
        COIN_CHEST = ModBlocks.register("coin_chest", () -> new CoinChestBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.5f, Float.POSITIVE_INFINITY).sound(SoundType.WOOD)));
        TAX_COLLECTOR = ModBlocks.register("tax_block", () -> new TaxCollectorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, Float.POSITIVE_INFINITY).sound(SoundType.METAL)));
        MONEY_BAG = ModBlocks.register("money_bag", ModBlocks.getMoneyBagGenerator(), () -> new MoneyBagBlock(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(0.1f, 2.0f).sound(SoundType.COBWEB)));
        PIGGY_BANK = ModBlocks.register("piggy_bank", ModBlocks.getCoinJarGenerator(), () -> new CoinJarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).strength(0.1f, 2.0f).sound(SoundType.STONE), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)));
        COINJAR_BLUE = ModBlocks.register("coinjar_blue", ModBlocks.getCoinJarGenerator(), () -> new CoinJarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).strength(0.1f, 2.0f).sound(SoundType.STONE), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)));
        SUS_JAR = ModBlocks.register("sus_jar", ModBlocks.getCoinJarGenerator(), () -> new CoinJarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).strength(0.1f, 2.0f).sound(SoundType.STONE), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), true));
        AUCTION_STAND = ModBlocks.registerWooden("auction_stand", WoodType.Attributes.needsLog, w -> new AuctionStandBlock(BlockBehaviour.Properties.of().mapColor(w.mapColor).strength(2.0f)));
    }
}

