/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.TeamBankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.source.builtin.PlayerBankAccountSource;
import io.github.lightman314.lightmanscurrency.api.money.bank.source.builtin.TeamBankAccountSource;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.api.teams.TeamAPI;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.MoneyValueArgument;
import io.github.lightman314.lightmanscurrency.common.data.types.BankDataCache;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandBank {
    private static final DynamicCommandExceptionType INVALID_PLAYER_INPUT_TYPE = new DynamicCommandExceptionType(xva$0 -> LCText.COMMAND_BANK_DELETE_PLAYER_INVALID_INPUT.get(xva$0));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        LiteralArgumentBuilder bankCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lcbank").requires(stack -> stack.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"give").then(Commands.literal((String)"all").then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(c -> CommandBank.giveAll((CommandContext<CommandSourceStack>)c, true))).then(Commands.argument((String)"notifyPlayers", (ArgumentType)BoolArgumentType.bool()).executes(c -> CommandBank.giveAll((CommandContext<CommandSourceStack>)c, BoolArgumentType.getBool((CommandContext)c, (String)"notifyPlayers"))))))).then(Commands.literal((String)"allPlayers").then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(c -> CommandBank.giveAllPlayers((CommandContext<CommandSourceStack>)c, true))).then(Commands.argument((String)"notifyPlayers", (ArgumentType)BoolArgumentType.bool()).executes(c -> CommandBank.giveAllPlayers((CommandContext<CommandSourceStack>)c, BoolArgumentType.getBool((CommandContext)c, (String)"notifyPlayers"))))))).then(Commands.literal((String)"allTeams").then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(c -> CommandBank.giveAllTeams((CommandContext<CommandSourceStack>)c, true))).then(Commands.argument((String)"notifyPlayers", (ArgumentType)BoolArgumentType.bool()).executes(c -> CommandBank.giveAllTeams((CommandContext<CommandSourceStack>)c, BoolArgumentType.getBool((CommandContext)c, (String)"notifyPlayers"))))))).then(Commands.literal((String)"players").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(c -> CommandBank.givePlayers((CommandContext<CommandSourceStack>)c, true))).then(Commands.argument((String)"notifyPlayers", (ArgumentType)BoolArgumentType.bool()).executes(c -> CommandBank.givePlayers((CommandContext<CommandSourceStack>)c, BoolArgumentType.getBool((CommandContext)c, (String)"notifyPlayers")))))))).then(Commands.literal((String)"team").then(Commands.argument((String)"teamID", (ArgumentType)LongArgumentType.longArg((long)0L)).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(c -> CommandBank.giveTeam((CommandContext<CommandSourceStack>)c, true))).then(Commands.argument((String)"notifyPlayers", (ArgumentType)BoolArgumentType.bool()).executes(c -> CommandBank.giveTeam((CommandContext<CommandSourceStack>)c, BoolArgumentType.getBool((CommandContext)c, (String)"notifyPlayers"))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"take").then(Commands.literal((String)"all").then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(c -> CommandBank.takeAll((CommandContext<CommandSourceStack>)c, true))).then(Commands.argument((String)"notifyPlayers", (ArgumentType)BoolArgumentType.bool()).executes(c -> CommandBank.takeAll((CommandContext<CommandSourceStack>)c, BoolArgumentType.getBool((CommandContext)c, (String)"notifyPlayers"))))))).then(Commands.literal((String)"allPlayers").then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(c -> CommandBank.takeAllPlayers((CommandContext<CommandSourceStack>)c, true))).then(Commands.argument((String)"notifyPlayers", (ArgumentType)BoolArgumentType.bool()).executes(c -> CommandBank.takeAllPlayers((CommandContext<CommandSourceStack>)c, BoolArgumentType.getBool((CommandContext)c, (String)"notifyPlayers"))))))).then(Commands.literal((String)"allTeams").then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(c -> CommandBank.takeAllTeams((CommandContext<CommandSourceStack>)c, true))).then(Commands.argument((String)"notifyPlayers", (ArgumentType)BoolArgumentType.bool()).executes(c -> CommandBank.takeAllTeams((CommandContext<CommandSourceStack>)c, BoolArgumentType.getBool((CommandContext)c, (String)"notifyPlayers"))))))).then(Commands.literal((String)"players").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(c -> CommandBank.takePlayers((CommandContext<CommandSourceStack>)c, true))).then(Commands.argument((String)"notifyPlayers", (ArgumentType)BoolArgumentType.bool()).executes(c -> CommandBank.takePlayers((CommandContext<CommandSourceStack>)c, BoolArgumentType.getBool((CommandContext)c, (String)"notifyPlayers")))))))).then(Commands.literal((String)"team").then(Commands.argument((String)"teamID", (ArgumentType)LongArgumentType.longArg((long)0L)).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(c -> CommandBank.takeTeam((CommandContext<CommandSourceStack>)c, true))).then(Commands.argument((String)"notifyPlayers", (ArgumentType)BoolArgumentType.bool()).executes(c -> CommandBank.takeTeam((CommandContext<CommandSourceStack>)c, BoolArgumentType.getBool((CommandContext)c, (String)"notifyPlayers"))))))))).then(Commands.literal((String)"delete").then(((LiteralArgumentBuilder)Commands.literal((String)"player").then(Commands.literal((String)"online").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(CommandBank::deletePlayerAccount)))).then(Commands.literal((String)"offline").then(Commands.argument((String)"nameOrID", (ArgumentType)StringArgumentType.word()).executes(CommandBank::deleteOfflinePlayerAccount)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"view").then(((LiteralArgumentBuilder)Commands.literal((String)"player").then(Commands.literal((String)"online").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(CommandBank::viewPlayerAccount)))).then(Commands.literal((String)"offline").then(Commands.argument((String)"nameOrID", (ArgumentType)StringArgumentType.word()).executes(CommandBank::viewOfflinePlayerAccount))))).then(Commands.literal((String)"team").then(Commands.argument((String)"teamID", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(CommandBank::viewTeamAccount))));
        dispatcher.register(bankCommand);
    }

    static int giveAll(CommandContext<CommandSourceStack> commandContext, boolean notifyPlayers) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.giveTo((CommandSourceStack)commandContext.getSource(), BankAPI.API.GetAllBankReferences(false), amount, notifyPlayers);
    }

    static int giveAllPlayers(CommandContext<CommandSourceStack> commandContext, boolean notifyPlayers) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.giveTo((CommandSourceStack)commandContext.getSource(), PlayerBankAccountSource.INSTANCE.CollectAllReferences(false), amount, notifyPlayers);
    }

    static int giveAllTeams(CommandContext<CommandSourceStack> commandContext, boolean notifyPlayers) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.giveTo((CommandSourceStack)commandContext.getSource(), TeamBankAccountSource.INSTANCE.CollectAllReferences(false), amount, notifyPlayers);
    }

    static int givePlayers(CommandContext<CommandSourceStack> commandContext, boolean notifyPlayers) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.giveTo((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayers(commandContext, (String)"players").stream().map(PlayerBankReference::of).toList(), amount, notifyPlayers);
    }

    static int giveTeam(CommandContext<CommandSourceStack> commandContext, boolean notifyPlayers) throws CommandSyntaxException {
        long teamID = LongArgumentType.getLong(commandContext, (String)"teamID");
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        ITeam team = TeamAPI.API.GetTeam(false, teamID);
        if (team == null) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_BANK_TEAM_NULL.get(teamID));
            return 0;
        }
        if (!team.hasBankAccount()) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_BANK_TEAM_NO_BANK.get(teamID));
            return 0;
        }
        return CommandBank.giveTo(source, Lists.newArrayList((Object[])new BankReference[]{team.getBankReference()}), amount, notifyPlayers);
    }

    static int giveTo(CommandSourceStack source, List<BankReference> accounts, MoneyValue amount, boolean notifyPlayers) {
        int count = 0;
        MutableComponent bankName = null;
        for (BankReference account : accounts) {
            if (!BankAPI.API.BankDepositFromServer(account.get(), amount, notifyPlayers) || ++count != 1) continue;
            bankName = account.get().getName();
        }
        if (count < 1) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_BANK_GIVE_FAIL.get(new Object[0]));
        } else if (count == 1) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_BANK_GIVE_SUCCESS_SINGLE.get(amount.getText(), bankName), true);
        } else {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_BANK_GIVE_SUCCESS.get(amount.getText(), count), true);
        }
        return count;
    }

    static int takeAll(CommandContext<CommandSourceStack> commandContext, boolean notifyPlayers) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.takeFrom((CommandSourceStack)commandContext.getSource(), BankAPI.API.GetAllBankReferences(false), amount, notifyPlayers);
    }

    static int takeAllPlayers(CommandContext<CommandSourceStack> commandContext, boolean notifyPlayers) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.takeFrom((CommandSourceStack)commandContext.getSource(), PlayerBankAccountSource.INSTANCE.CollectAllReferences(false), amount, notifyPlayers);
    }

    static int takeAllTeams(CommandContext<CommandSourceStack> commandContext, boolean notifyPlayers) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.takeFrom((CommandSourceStack)commandContext.getSource(), TeamBankAccountSource.INSTANCE.CollectAllReferences(false), amount, notifyPlayers);
    }

    static int takePlayers(CommandContext<CommandSourceStack> commandContext, boolean notifyPlayers) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.takeFrom((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayers(commandContext, (String)"players").stream().map(PlayerBankReference::of).toList(), amount, notifyPlayers);
    }

    static int takeTeam(CommandContext<CommandSourceStack> commandContext, boolean notifyPlayers) throws CommandSyntaxException {
        long teamID = LongArgumentType.getLong(commandContext, (String)"teamID");
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        ITeam team = TeamAPI.API.GetTeam(false, teamID);
        if (team == null) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_BANK_TEAM_NULL.get(teamID));
            return 0;
        }
        if (!team.hasBankAccount()) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_BANK_TEAM_NO_BANK.get(teamID));
            return 0;
        }
        return CommandBank.takeFrom((CommandSourceStack)commandContext.getSource(), Lists.newArrayList((Object[])new BankReference[]{team.getBankReference()}), amount, notifyPlayers);
    }

    static int takeFrom(CommandSourceStack source, List<BankReference> accounts, MoneyValue amount, boolean notifyPlayers) {
        int count = 0;
        MutableComponent bankName = null;
        MoneyValue largestAmount = MoneyValue.empty();
        for (BankReference account : accounts) {
            Pair<Boolean, MoneyValue> result = BankAPI.API.BankWithdrawFromServer(account.get(), amount, notifyPlayers);
            if (!((Boolean)result.getFirst()).booleanValue()) continue;
            if (++count == 1) {
                bankName = account.get().getName();
            }
            if (((MoneyValue)result.getSecond()).getCoreValue() <= largestAmount.getCoreValue()) continue;
            largestAmount = (MoneyValue)result.getSecond();
        }
        if (count < 1) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_BANK_TAKE_FAIL.get(new Object[0]));
        } else if (count == 1) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_BANK_TAKE_SUCCESS_SINGLE.get(largestAmount.getText(), bankName), true);
        } else {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_BANK_TAKE_SUCCESS.get(largestAmount.getText(), count), true);
        }
        return count;
    }

    static int deletePlayerAccount(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        BankDataCache.TYPE.get(false).deleteAccount(player.getUUID());
        EasyText.sendCommandSucess((CommandSourceStack)context.getSource(), (Component)LCText.COMMAND_BANK_DELETE_PLAYER_RESET.get(player.getDisplayName()), true);
        return 1;
    }

    static int deleteOfflinePlayerAccount(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String input = StringArgumentType.getString(context, (String)"nameOrID");
        try {
            UUID playerID = UUID.fromString(input);
            PlayerReference pr = PlayerReference.of(playerID, "");
            return CommandBank.handleDeletion(pr, (CommandSourceStack)context.getSource());
        }
        catch (IllegalArgumentException e) {
            PlayerReference pr = PlayerReference.of(false, input);
            if (pr != null) {
                return CommandBank.handleDeletion(pr, (CommandSourceStack)context.getSource());
            }
            throw INVALID_PLAYER_INPUT_TYPE.create((Object)input);
        }
    }

    private static int handleDeletion(@Nonnull PlayerReference player, @Nonnull CommandSourceStack source) {
        if (BankDataCache.TYPE.get(false).deleteAccount(player.id)) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_BANK_DELETE_PLAYER_SUCCESS.get(player.getName(false)), true);
            return 1;
        }
        EasyText.sendCommandFail(source, (Component)LCText.COMMAND_BANK_DELETE_PLAYER_DOESNT_EXIST.get(player.getName(false)));
        return 0;
    }

    private static int viewPlayerAccount(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        return CommandBank.viewAccount(context, PlayerBankReference.of((Player)player));
    }

    private static int viewOfflinePlayerAccount(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String input = StringArgumentType.getString(context, (String)"nameOrID");
        try {
            UUID playerID = UUID.fromString(input);
            PlayerReference pr = PlayerReference.of(playerID, "");
            BankDataCache data = BankDataCache.TYPE.get(false);
            if (!data.hasAccount(playerID)) {
                EasyText.sendCommandFail(context, (Component)LCText.COMMAND_BANK_VIEW_PLAYER_NO_ACCOUNT.get(pr.getName(false)));
                return 0;
            }
            return CommandBank.viewAccount(context, PlayerBankReference.of(playerID));
        }
        catch (IllegalArgumentException e) {
            PlayerReference pr = PlayerReference.of(false, input);
            if (pr != null) {
                return CommandBank.viewAccount(context, PlayerBankReference.of(pr));
            }
            throw INVALID_PLAYER_INPUT_TYPE.create((Object)input);
        }
    }

    private static int viewTeamAccount(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        long teamID = LongArgumentType.getLong(context, (String)"teamID");
        ITeam team = TeamAPI.API.GetTeam(false, teamID);
        if (team == null) {
            EasyText.sendCommandFail(context, (Component)LCText.COMMAND_BANK_TEAM_NULL.get(teamID));
            return 0;
        }
        if (!team.hasBankAccount()) {
            EasyText.sendCommandFail(context, (Component)LCText.COMMAND_BANK_TEAM_NO_BANK.get(teamID));
            return 0;
        }
        return CommandBank.viewAccount(context, TeamBankReference.of(team));
    }

    private static int viewAccount(CommandContext<CommandSourceStack> context, BankReference reference) {
        IBankAccount account = reference.get();
        if (account == null) {
            if (account.getMoneyStorage().isEmpty()) {
                EasyText.sendCommandSucess(context, (Component)LCText.COMMAND_BANK_VIEW_EMPTY.get(account.getName()), false);
            } else {
                EasyText.sendCommandSucess(context, (Component)LCText.COMMAND_BANK_VIEW_SUCCESS.get(account.getName()), false);
                for (MoneyValue value : account.getStoredMoney().allValues()) {
                    EasyText.sendCommandSucess(context, (Component)value.getText(), false);
                }
            }
            return 1;
        }
        EasyText.sendCommandFail(context, (Component)LCText.COMMAND_BANK_VIEW_DOESNT_EXIST.get(new Object[0]));
        return 0;
    }
}

