/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IEasyEntityBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.LazyShapes;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.RotatableBlock;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinJarBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.util.LookupHelper;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoinJarBlock
extends RotatableBlock
implements IEasyEntityBlock {
    private final boolean invertRotation;

    public CoinJarBlock(BlockBehaviour.Properties properties) {
        this(properties, LazyShapes.BOX);
    }

    public CoinJarBlock(BlockBehaviour.Properties properties, VoxelShape shape) {
        this(properties, shape, false);
    }

    public CoinJarBlock(BlockBehaviour.Properties properties, VoxelShape shape, boolean invertRotation) {
        super(properties, shape);
        this.invertRotation = invertRotation;
    }

    @Override
    protected boolean isBlockOpaque() {
        return false;
    }

    @Override
    public int getRotationY(Direction facing) {
        if (this.invertRotation) {
            return this.getRotationYInv(facing);
        }
        return super.getRotationY(facing);
    }

    @Override
    @Nonnull
    public Collection<BlockEntityType<?>> getAllowedTypes() {
        return ImmutableList.of(ModBlockEntities.COIN_JAR.get());
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new CoinJarBlockEntity(pos, state);
    }

    @Override
    public void setPlacedBy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity player, @Nonnull ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CoinJarBlockEntity) {
            CoinJarBlockEntity jar = (CoinJarBlockEntity)blockEntity;
            jar.readItemData(stack);
        }
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack item, @Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (!level.isClientSide) {
            CoinJarBlockEntity jar;
            ItemStack coinStack = player.getItemInHand(hand);
            if (!CoinAPI.API.IsAllowedInCoinContainer(coinStack, false)) {
                return ItemInteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CoinJarBlockEntity && (jar = (CoinJarBlockEntity)blockEntity).addCoin(coinStack)) {
                coinStack.shrink(1);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nonnull
    public BlockState playerWillDestroy(Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof CoinJarBlockEntity) {
            CoinJarBlockEntity jarEntity = (CoinJarBlockEntity)tileEntity;
            Holder<Enchantment> silkTouch = LookupHelper.lookupEnchantment((HolderLookup.Provider)player.registryAccess(), (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH);
            if (silkTouch != null && EnchantmentHelper.getEnchantmentLevel(silkTouch, (LivingEntity)player) > 0) {
                ItemStack dropStack = new ItemStack((ItemLike)this, 1);
                jarEntity.addFullData(dropStack);
                jarEntity.clearStorage();
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)dropStack);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onRemove(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean flag) {
        if (state.is(newState.getBlock())) {
            super.onRemove(state, level, pos, newState, flag);
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CoinJarBlockEntity) {
            CoinJarBlockEntity jarEntity = (CoinJarBlockEntity)blockEntity;
            jarEntity.getStorage().forEach(coin -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)coin));
            jarEntity.clearStorage();
        }
    }

    @Override
    @Nonnull
    public ItemStack getCloneItemStack(@Nonnull BlockState state, @Nonnull HitResult target, @Nonnull LevelReader level, @Nonnull BlockPos pos, @Nonnull Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CoinJarBlockEntity) {
            CoinJarBlockEntity jarBlock = (CoinJarBlockEntity)blockEntity;
            if (player.isCreative() && player.isCrouching()) {
                jarBlock.addFullData(stack);
            } else {
                jarBlock.addSimpleData(stack);
            }
        }
        return stack;
    }
}

