/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.lightman314.lightmanscurrency.client.util.LCRenderTypes;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class OutlineUtil {
    private static final long SLIDE_SPEED = 3000L;
    private static final float BOX_SPLIT_SIZE = 32.0f;

    public static Vector4f decodeColor(int color, float alpha) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Vector4f(r, g, b, alpha);
    }

    public static Vector4f decodeColor(int color) {
        float r = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float b = (float)(color >> 8 & 0xFF) / 255.0f;
        float a = (float)(color & 0xFF) / 255.0f;
        return new Vector4f(r, g, b, a);
    }

    public static void renderBox(@Nonnull PoseStack pose, @Nonnull MultiBufferSource buffer, @Nonnull AABB area, int color) {
        OutlineUtil.renderBox(pose, buffer, area, OutlineUtil.decodeColor(color));
    }

    public static void renderBox(@Nonnull PoseStack pose, @Nonnull MultiBufferSource buffer, @Nonnull AABB area, int color, float alpha) {
        OutlineUtil.renderBox(pose, buffer, area, OutlineUtil.decodeColor(color, alpha));
    }

    public static void renderBox(@Nonnull PoseStack pose, @Nonnull MultiBufferSource buffer, @Nonnull AABB area, Vector4f color) {
        Vec3 camera = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        float inflate = 0.015625f;
        Vector3f minPos = new Vector3f((float)area.minX + inflate, (float)area.minY + inflate, (float)area.minZ + inflate);
        Vector3f maxPos = new Vector3f((float)area.maxX - inflate, (float)area.maxY - inflate, (float)area.maxZ - inflate);
        OutlineUtil.renderBoxFaces(pose, buffer, minPos, maxPos, color);
        VertexConsumer consumer = buffer.getBuffer(RenderType.lines());
        LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)consumer, (double)minPos.x(), (double)minPos.y(), (double)minPos.z(), (double)maxPos.x(), (double)maxPos.y(), (double)maxPos.z(), (float)color.x(), (float)color.y(), (float)color.z(), (float)1.0f);
    }

    private static void renderBoxFaces(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, Vector3f minPos, Vector3f maxPos, Vector4f color) {
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer consumer = buffer.getBuffer(LCRenderTypes.getTaxArea());
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.NORTH, color);
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.SOUTH, color);
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.EAST, color);
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.WEST, color);
        float startX = minPos.x();
        float stopX = maxPos.x();
        float startZ = minPos.z();
        float stopZ = maxPos.z();
        float x = startX;
        while (x < stopX) {
            float maxX = x + Math.min(stopX - x, 32.0f);
            float z = startZ;
            while (z < stopZ) {
                float maxZ = z + Math.min(stopZ - z, 32.0f);
                Vector3f newMin = new Vector3f(x, minPos.y(), z);
                Vector3f newMax = new Vector3f(maxX, maxPos.y(), maxZ);
                OutlineUtil.renderBoxFace(pose, consumer, newMin, newMax, Direction.UP, color);
                OutlineUtil.renderBoxFace(pose, consumer, newMin, newMax, Direction.DOWN, color);
                z = maxZ;
            }
            x = maxX;
        }
    }

    private static void renderBoxFace(@Nonnull PoseStack.Pose pose, @Nonnull VertexConsumer consumer, Vector3f minPos, Vector3f maxPos, Direction face, Vector4f color) {
        Vector3f pos0 = new Vector3f();
        Vector3f pos1 = new Vector3f();
        Vector3f pos2 = new Vector3f();
        Vector3f pos3 = new Vector3f();
        Vector3f normal = new Vector3f();
        float minX = minPos.x();
        float minY = minPos.y();
        float minZ = minPos.z();
        float maxX = maxPos.x();
        float maxY = maxPos.y();
        float maxZ = maxPos.z();
        float uv0 = (float)(TimeUtil.getCurrentTime() % 3000L) / 3000.0f;
        float uv1 = 1.0f;
        float uv2 = 1.0f;
        switch (face) {
            case DOWN: {
                pos0.set(maxX, minY, minZ);
                pos1.set(maxX, minY, maxZ);
                pos2.set(minX, minY, maxZ);
                pos3.set(minX, minY, minZ);
                normal.set(0.0f, -1.0f, 0.0f);
                uv1 = maxZ - minZ + uv0;
                uv2 = maxX - minX + uv0;
                break;
            }
            case UP: {
                pos0.set(minX, maxY, minZ);
                pos1.set(minX, maxY, maxZ);
                pos2.set(maxX, maxY, maxZ);
                pos3.set(maxX, maxY, minZ);
                normal.set(0.0f, 1.0f, 0.0f);
                uv1 = maxZ - minZ + uv0;
                uv2 = maxX - minX + uv0;
                break;
            }
            case NORTH: {
                pos0.set(maxX, maxY, minZ);
                pos1.set(maxX, minY, minZ);
                pos2.set(minX, minY, minZ);
                pos3.set(minX, maxY, minZ);
                normal.set(0.0f, 0.0f, -1.0f);
                uv1 = maxY - minY + uv0;
                uv2 = maxX - minX + uv0;
                break;
            }
            case SOUTH: {
                pos0.set(minX, maxY, maxZ);
                pos1.set(minX, minY, maxZ);
                pos2.set(maxX, minY, maxZ);
                pos3.set(maxX, maxY, maxZ);
                normal.set(0.0f, 0.0f, 1.0f);
                uv1 = maxY - minY + uv0;
                uv2 = maxX - minX + uv0;
                break;
            }
            case WEST: {
                pos0.set(minX, maxY, minZ);
                pos1.set(minX, minY, minZ);
                pos2.set(minX, minY, maxZ);
                pos3.set(minX, maxY, maxZ);
                normal.set(-1.0f, 0.0f, 0.0f);
                uv1 = maxY - minY + uv0;
                uv2 = maxZ - minZ + uv0;
                break;
            }
            case EAST: {
                pos0.set(maxX, maxY, maxZ);
                pos1.set(maxX, minY, maxZ);
                pos2.set(maxX, minY, minZ);
                pos3.set(maxX, maxY, minZ);
                normal.set(1.0f, 0.0f, 0.0f);
                uv1 = maxY - minY + uv0;
                uv2 = maxZ - minZ + uv0;
            }
        }
        Matrix4f posMatrix = pose.pose();
        Vector4f posTransformTemp = new Vector4f(pos0.x(), pos0.y(), pos0.z(), 1.0f);
        posTransformTemp.set(pos0.x(), pos0.y(), pos0.z(), 1.0f);
        posTransformTemp.mul((Matrix4fc)posMatrix);
        float x0 = posTransformTemp.x();
        float y0 = posTransformTemp.y();
        float z0 = posTransformTemp.z();
        posTransformTemp.set(pos1.x(), pos1.y(), pos1.z(), 1.0f);
        posTransformTemp.mul((Matrix4fc)posMatrix);
        float x1 = posTransformTemp.x();
        float y1 = posTransformTemp.y();
        float z1 = posTransformTemp.z();
        posTransformTemp.set(pos2.x(), pos2.y(), pos2.z(), 1.0f);
        posTransformTemp.mul((Matrix4fc)posMatrix);
        float x2 = posTransformTemp.x();
        float y2 = posTransformTemp.y();
        float z2 = posTransformTemp.z();
        posTransformTemp.set(pos3.x(), pos3.y(), pos3.z(), 1.0f);
        posTransformTemp.mul((Matrix4fc)posMatrix);
        float x3 = posTransformTemp.x();
        float y3 = posTransformTemp.y();
        float z3 = posTransformTemp.z();
        float r = color.x();
        float g = color.y();
        float b = color.z();
        float a = color.w();
        Vector3f normalTransformTemp = new Vector3f();
        normalTransformTemp.set((Vector3fc)normal);
        normalTransformTemp.mul((Matrix3fc)pose.normal());
        float nx = normalTransformTemp.x();
        float ny = normalTransformTemp.y();
        float nz = normalTransformTemp.z();
        consumer.addVertex(x0, y0, z0).setColor(r, g, b, a).setUv(uv0, uv0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(nx, ny, nz);
        consumer.addVertex(x1, y1, z1).setColor(r, g, b, a).setUv(uv0, uv1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(nx, ny, nz);
        consumer.addVertex(x2, y2, z2).setColor(r, g, b, a).setUv(uv2, uv1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(nx, ny, nz);
        consumer.addVertex(x3, y3, z3).setColor(r, g, b, a).setUv(uv2, uv0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(nx, ny, nz);
    }
}

