/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.util.OutlineUtil;
import io.github.lightman314.lightmanscurrency.common.data.types.TaxDataCache;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="lightmanscurrency")
public class TaxBlockRenderer {
    @SubscribeEvent
    public static void onLevelRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            LocalPlayer player = Minecraft.getInstance().player;
            ClientLevel level = Minecraft.getInstance().level;
            PoseStack pose = event.getPoseStack();
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            double cameraX = event.getCamera().getPosition().x();
            double cameraY = event.getCamera().getPosition().y();
            double cameraZ = event.getCamera().getPosition().z();
            for (TaxEntry entry : TaxDataCache.TYPE.get(true).getAllEntries()) {
                if (!TaxBlockRenderer.shouldRenderEntry(entry, (Level)level, (Player)player, event.getCamera().getPosition())) continue;
                pose.pushPose();
                int radius = entry.getRadius();
                int height = entry.getHeight();
                int vertOffset = entry.getVertOffset();
                AABB renderArea = new AABB((double)(-radius), (double)vertOffset, (double)(-radius), (double)radius + 1.0, (double)(vertOffset + height), (double)radius + 1.0);
                BlockPos center = entry.getCenter().getPos();
                pose.translate((double)center.getX() - cameraX, (double)center.getY() - cameraY, (double)center.getZ() - cameraZ);
                OutlineUtil.renderBox(pose, (MultiBufferSource)buffer, renderArea, entry.getRenderColor((Player)player), 0.5f);
                pose.popPose();
            }
        }
    }

    private static boolean shouldRenderEntry(@Nonnull TaxEntry entry, @Nonnull Level level, @Nonnull Player player, @Nonnull Vec3 cameraPos) {
        BlockPos center = entry.getCenter().getPos();
        double renderDistance = 256.0 + (double)entry.getRadius();
        return entry.shouldRender(player) && entry.getCenter().sameDimension(level) && center.distToCenterSqr(cameraPos.x, cameraPos.y, cameraPos.z) <= renderDistance * renderDistance;
    }
}

