/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.base.InterfaceStatsTab;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class InterfaceStatsClientTab
extends TraderInterfaceClientTab<InterfaceStatsTab>
implements IScrollable {
    private static final int LINE_COUNT = 10;
    private static final int LINE_SIZE = 10;
    private static final int START_POS = 37;
    private int scroll = 0;

    public InterfaceStatsClientTab(Object screen, InterfaceStatsTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconUtil.ICON_PRICE_FLUCTUATION;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_INTERFACE_STATS.get(new Object[0]);
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(10, 10))).width(screenArea.width - 20)).text(LCText.BUTTON_TRADER_STATS_CLEAR).pressAction(() -> ((InterfaceStatsTab)this.commonTab).clearStats(Screen.hasShiftDown()))).build());
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(screenArea.width - 10 - 8, 37))).height(100).scrollable(this).build());
        this.addChild(((ScrollListener.Builder)ScrollListener.builder().area(screenArea.ofSize(screenArea.width, 137))).listener(this).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        this.validateScroll();
        int yPos = 37;
        List<MutableComponent> lines = this.getLines();
        if (lines.isEmpty()) {
            TextRenderUtil.drawVerticallyCenteredMultilineText(gui, (Component)LCText.GUI_TRADER_STATS_EMPTY.get(new Object[0]), 10, ((TraderInterfaceScreen)this.screen).getXSize() - 20, yPos, 100, 0x404040);
        } else {
            for (int i = this.scroll; i < this.scroll + 10 && i < lines.size(); ++i) {
                gui.drawString((Component)lines.get(i), 10, yPos, 0x404040);
                yPos += 10;
            }
        }
    }

    private List<MutableComponent> getLines() {
        TraderInterfaceBlockEntity be = ((TraderInterfaceMenu)this.menu).getBE();
        if (be == null) {
            return new ArrayList<MutableComponent>();
        }
        return be.statTracker.getDisplayLines();
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(10, this.getLines().size());
    }
}

