/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.input.builtin;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.ValueDisplayData;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.builtin.NumberDisplay;
import io.github.lightman314.lightmanscurrency.api.money.input.templates.SimpleDisplayInput;
import io.github.lightman314.lightmanscurrency.api.money.types.builtin.CoinCurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;

public class CoinDisplayInput
extends SimpleDisplayInput {
    private final ChainData chain;

    public CoinDisplayInput(@Nonnull ChainData chain) {
        this.chain = chain;
        this.setPrefixAndPostfix();
    }

    @Override
    @Nonnull
    public Component inputName() {
        return this.chain.getDisplayName();
    }

    @Override
    @Nonnull
    public String getUniqueName() {
        return MoneyValue.generateCustomUniqueName(CoinCurrencyType.TYPE, this.chain.chain);
    }

    private void setPrefixAndPostfix() {
        ValueDisplayData valueDisplayData = this.chain.getDisplayData();
        if (valueDisplayData instanceof NumberDisplay) {
            NumberDisplay nd = (NumberDisplay)valueDisplayData;
            Pair<String, String> format = nd.getSplitWordyFormat();
            this.setPrefix((String)format.getFirst());
            this.setPostfix((String)format.getSecond());
        }
    }

    @Override
    @Nonnull
    protected MoneyValue getValueFromInput(double inputValue) {
        return this.chain.getDisplayData().parseDisplayInput(inputValue);
    }

    @Override
    protected double getTextFromDisplay(@Nonnull MoneyValue value) {
        CoinValue coinValue;
        double valueNumber = 0.0;
        if (value instanceof CoinValue && (coinValue = (CoinValue)value).getChain().equals(this.chain.chain)) {
            ValueDisplayData valueDisplayData = this.chain.getDisplayData();
            if (valueDisplayData instanceof NumberDisplay) {
                NumberDisplay nd = (NumberDisplay)valueDisplayData;
                valueNumber = nd.getDisplayValue(coinValue.getCoreValue());
            } else {
                valueNumber = coinValue.getCoreValue();
            }
        }
        return valueNumber;
    }
}

