/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReferenceType;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.api.teams.TeamAPI;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class TeamBankReference
extends BankReference {
    public static final BankReferenceType TYPE = new Type();
    public final long teamID;

    protected TeamBankReference(long teamID) {
        super(TYPE);
        this.teamID = teamID;
    }

    public static BankReference of(long teamID) {
        return new TeamBankReference(teamID);
    }

    public static BankReference of(@Nonnull ITeam team) {
        BankReference br = TeamBankReference.of(team.getID());
        br.flagAsClient(team.isClient());
        return br;
    }

    @Override
    @Nullable
    public IconData getIcon() {
        return IconUtil.ICON_ALEX_HEAD;
    }

    @Override
    @Nullable
    public IBankAccount get() {
        ITeam team = TeamAPI.API.GetTeam(this, this.teamID);
        if (team != null) {
            return team.getBankAccount();
        }
        return null;
    }

    @Override
    public boolean allowedAccess(@Nonnull PlayerReference player) {
        ITeam team = TeamAPI.API.GetTeam(this, this.teamID);
        if (team != null && team.hasBankAccount()) {
            return team.canAccessBankAccount(player);
        }
        return false;
    }

    @Override
    public boolean allowedAccess(@Nonnull Player player) {
        ITeam team = TeamAPI.API.GetTeam(this.isClient(), this.teamID);
        if (team != null && team.hasBankAccount()) {
            return team.canAccessBankAccount(player);
        }
        return false;
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag tag) {
        tag.putLong("TeamID", this.teamID);
    }

    @Override
    protected void encodeAdditional(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeLong(this.teamID);
    }

    private static class Type
    extends BankReferenceType {
        protected Type() {
            super(VersionUtil.lcResource("team_account"));
        }

        @Override
        public BankReference load(CompoundTag tag) {
            return TeamBankReference.of(tag.getLong("TeamID"));
        }

        @Override
        public BankReference decode(FriendlyByteBuf buffer) {
            return TeamBankReference.of(buffer.readLong());
        }
    }
}

