/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money;

import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.types.CurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.common.impl.MoneyAPIImpl;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class MoneyAPI {
    public static final String MODID = "lightmanscurrency";
    public static final MoneyAPI API = MoneyAPIImpl.INSTANCE;

    public abstract List<CurrencyType> AllCurrencyTypes();

    @Nullable
    public abstract CurrencyType GetRegisteredCurrencyType(ResourceLocation var1);

    public abstract void RegisterCurrencyType(CurrencyType var1);

    public abstract IMoneyHolder GetPlayersMoneyHandler(Player var1);

    public final IMoneyHandler GetContainersMoneyHandler(Container container, Player player) {
        return this.CreateContainersMoneyHandler(container, s -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)s), IClientTracker.entityWrapper((Entity)player));
    }

    public final IMoneyHandler GetContainersMoneyHandler(Container container, Consumer<ItemStack> overflowHandler, IClientTracker tracker) {
        return this.CreateContainersMoneyHandler(container, overflowHandler, tracker);
    }

    protected abstract IMoneyHandler CreateContainersMoneyHandler(Container var1, Consumer<ItemStack> var2, IClientTracker var3);

    public abstract IMoneyHandler GetATMMoneyHandler(Player var1, Container var2);

    public abstract boolean ItemAllowedInMoneySlot(Player var1, ItemStack var2);
}

