/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config;

import com.google.common.collect.ImmutableMap;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.event.SyncedConfigEvent;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketSyncConfig;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public abstract class SyncedConfigFile
extends ConfigFile {
    private static final Map<ResourceLocation, SyncedConfigFile> fileMap = new HashMap<ResourceLocation, SyncedConfigFile>();
    private boolean loadedSyncData = false;

    @Override
    public boolean isServerOnly() {
        return true;
    }

    public static void playerJoined(@Nonnull ServerPlayer player) {
        fileMap.values().forEach((? super T c) -> c.sendSyncPacket((Player)player));
    }

    public static void handleSyncData(@Nonnull ResourceLocation configID, @Nonnull Map<String, String> data) {
        if (fileMap.containsKey(configID)) {
            fileMap.get(configID).loadSyncData(data);
        } else {
            LightmansCurrency.LogError("Received config data for '" + String.valueOf(configID) + "' from the server, however this config is not present on the client!");
        }
    }

    public static void onClientLeavesServer() {
        fileMap.values().forEach(SyncedConfigFile::clearSyncedData);
    }

    protected SyncedConfigFile(@Nonnull String fileName, @Nonnull ResourceLocation id) {
        super(id, fileName, ConfigFile.LoadPhase.GAME_START);
        if (fileMap.containsKey(this.getFileID())) {
            throw new IllegalArgumentException("Synced Config " + String.valueOf(this.getFileID()) + " already exists!");
        }
        fileMap.put(this.getFileID(), this);
    }

    @Override
    public boolean isLoaded() {
        return super.isLoaded() || this.loadedSyncData;
    }

    @Override
    protected void afterReload() {
        this.sendSyncPacket(null);
    }

    @Override
    protected void afterOptionChanged(@Nonnull ConfigOption<?> option) {
        this.sendSyncPacket(null);
    }

    public final void clearSyncedData() {
        this.forEach(ConfigOption::clearSyncedData);
        this.loadedSyncData = false;
    }

    @Nonnull
    private Map<String, String> getSyncData() {
        HashMap map = new HashMap();
        this.getAllOptions().forEach((? super K id, ? super V option) -> map.put(id, option.write()));
        return ImmutableMap.copyOf(map);
    }

    private void sendSyncPacket(@Nullable Player target) {
        if (target != null) {
            new SPacketSyncConfig(this.getFileID(), this.getSyncData()).sendTo(target);
        } else {
            new SPacketSyncConfig(this.getFileID(), this.getSyncData()).sendToAll();
        }
    }

    private void loadSyncData(@Nonnull Map<String, String> syncData) {
        NeoForge.EVENT_BUS.post((Event)new SyncedConfigEvent.ConfigReceivedSyncDataEvent.Pre(this));
        LightmansCurrency.LogInfo("Received config data for '" + String.valueOf(this.getFileID()) + "' from the server!");
        this.getAllOptions().forEach((? super K id, ? super V option) -> {
            if (syncData.containsKey(id)) {
                option.load((String)syncData.get(id), ConfigOption.LoadSource.SYNC);
            } else {
                LightmansCurrency.LogWarning("Received data for config option '" + id + "' but it is not present on the client!");
            }
            this.loadedSyncData = true;
        });
        NeoForge.EVENT_BUS.post((Event)new SyncedConfigEvent.ConfigReceivedSyncDataEvent.Post(this));
    }
}

