/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.EnumSet;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.io.ThemeLoader;
import journeymap.client.model.grid.GridSpec;
import journeymap.client.model.grid.GridSpecs;
import journeymap.client.model.map.MapType;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.buttons.FloatSliderButton;
import journeymap.client.ui.component.dropdown.PropertyDropdownButton;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeToggle;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.EnumField;
import journeymap.common.properties.config.FloatField;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class GridEditor
extends JmUILegacy {
    private final DynamicTexture colorPickTexture;
    private final int tileSize = 128;
    private final int sampleTextureSize = 128;
    private GridSpecs gridSpecs;
    private PropertyDropdownButton<GridSpec.Style> buttonStyle;
    private FloatSliderButton buttonOpacity;
    private CheckBox checkDay;
    private CheckBox checkNight;
    private CheckBox checkUnderground;
    private ThemeToggle buttonDay;
    private ThemeToggle buttonNight;
    private ThemeToggle buttonUnderground;
    private Integer activeColor;
    private MapType activeMapType;
    private Button buttonReset;
    private Button buttonCancel;
    private Button buttonClose;
    private Rectangle2D.Double colorPickRect;
    private ButtonList topButtons;
    private ButtonList leftButtons;
    private ButtonList leftChecks;
    private ButtonList bottomButtons;
    private ResourceLocation colorPicResource = Constants.birthdayMessage() == null ? TextureCache.ColorPicker : TextureCache.ColorPicker2;

    public GridEditor(Screen returnDisplay) {
        super(Constants.getString("jm.common.grid_editor"), returnDisplay);
        this.colorPickTexture = TextureCache.getTexture(this.colorPicResource);
        this.colorPickRect = new Rectangle2D.Double(0.0, 0.0, ((TextureAccess)this.colorPickTexture).journeymap$getWidth(), ((TextureAccess)this.colorPickTexture).journeymap$getHeight());
        this.gridSpecs = JourneymapClient.getInstance().getCoreProperties().gridSpecs.clone();
        this.activeMapType = MapType.day((ResourceKey<Level>)Level.OVERWORLD);
        this.activeColor = this.gridSpecs.getSpec(this.activeMapType).getColor();
    }

    @Override
    public void init() {
        try {
            this.setRenderBottomBar(true);
            if (this.getRenderables().isEmpty()) {
                GridSpec spec = this.gridSpecs.getSpec(this.activeMapType);
                this.buttonStyle = new PropertyDropdownButton<GridSpec.Style>(EnumSet.allOf(GridSpec.Style.class), Constants.getString("jm.common.grid_style"), new EnumField<GridSpec.Style>(Category.Hidden, "", spec.style), b -> this.updateGridSpecs());
                this.addRenderableWidget((GuiEventListener)this.buttonStyle);
                this.buttonStyle.setDefaultStyle(false);
                this.buttonStyle.setDrawBackground(false);
                this.buttonOpacity = new FloatSliderButton(new FloatField(Category.Hidden, "", 0.0f, 1.0f, spec.alpha), Constants.getString("jm.common.grid_opacity") + " : ", "");
                this.addRenderableWidget((GuiEventListener)this.buttonOpacity);
                this.buttonOpacity.setDefaultStyle(false);
                this.buttonOpacity.setDrawBackground(false);
                this.topButtons = new ButtonList(this.buttonStyle, this.buttonOpacity);
                this.topButtons.equalizeWidths(this.getFontRenderer());
                this.checkDay = new CheckBox("", this.activeMapType == MapType.day((ResourceKey<Level>)Level.OVERWORLD), b -> this.updatePreview(MapType.day((ResourceKey<Level>)Level.OVERWORLD)));
                this.addRenderableWidget((GuiEventListener)this.checkDay);
                this.checkNight = new CheckBox("", this.activeMapType == MapType.night((ResourceKey<Level>)Level.OVERWORLD), b -> this.updatePreview(MapType.night((ResourceKey<Level>)Level.OVERWORLD)));
                this.addRenderableWidget((GuiEventListener)this.checkNight);
                this.checkUnderground = new CheckBox("", this.activeMapType.isUnderground(), b -> this.updatePreview(MapType.underground(0, (ResourceKey<Level>)Level.OVERWORLD)));
                this.addRenderableWidget((GuiEventListener)this.checkUnderground);
                this.leftChecks = new ButtonList(this.checkDay, this.checkNight, this.checkUnderground);
                Theme theme = ThemeLoader.getCurrentTheme();
                this.buttonDay = new ThemeToggle(theme, "jm.fullscreen.map_day", "day", b -> this.updatePreview(MapType.day((ResourceKey<Level>)Level.OVERWORLD)));
                this.addRenderableWidget((GuiEventListener)this.buttonDay);
                this.buttonNight = new ThemeToggle(theme, "jm.fullscreen.map_night", "night", b -> this.updatePreview(MapType.night((ResourceKey<Level>)Level.OVERWORLD)));
                this.addRenderableWidget((GuiEventListener)this.buttonNight);
                this.buttonUnderground = new ThemeToggle(theme, "jm.fullscreen.map_caves", "caves", b -> this.updatePreview(MapType.underground(0, (ResourceKey<Level>)Level.OVERWORLD)));
                this.addRenderableWidget((GuiEventListener)this.buttonUnderground);
                this.leftButtons = new ButtonList(this.buttonDay, this.buttonNight, this.buttonUnderground);
                this.buttonReset = new Button(Constants.getString("jm.waypoint.reset"), b -> this.resetGridSpecs());
                this.addRenderableWidget((GuiEventListener)this.buttonReset);
                this.buttonReset.setDefaultStyle(false);
                this.buttonCancel = new Button(Constants.getString("jm.waypoint.cancel"), b -> {
                    this.resetGridSpecs();
                    this.closeAndReturn();
                });
                this.buttonCancel.setDefaultStyle(false);
                this.addRenderableWidget((GuiEventListener)this.buttonCancel);
                this.buttonClose = new Button(Constants.getString("jm.waypoint.save"), b -> this.saveAndClose());
                this.buttonClose.setDefaultStyle(false);
                this.addRenderableWidget((GuiEventListener)this.buttonClose);
                this.bottomButtons = new ButtonList(this.buttonReset, this.buttonCancel, this.buttonClose);
                this.bottomButtons.equalizeWidths(this.getFontRenderer());
                this.getRenderables().addAll(this.topButtons);
                this.getRenderables().addAll(this.leftChecks);
                this.getRenderables().addAll(this.leftButtons);
                this.getRenderables().addAll(this.bottomButtons);
                this.updatePreview(this.activeMapType);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    @Override
    protected void layoutButtons(GuiGraphics graphics) {
        try {
            this.init();
            int hgap = 6;
            int vgap = 6;
            int startY = Math.max(40, (this.height - 230) / 2);
            int centerX = this.width / 2;
            int cpSize = this.topButtons.getHeight(6);
            int topRowWidth = 6 + cpSize + ((Button)((Object)this.topButtons.get(0))).getWidth();
            int topRowLeft = centerX - topRowWidth / 2;
            this.topButtons.layoutVertical(topRowLeft + 6 + cpSize, startY, true, 6);
            this.drawColorPicker(graphics, topRowLeft, this.topButtons.getTopY(), cpSize);
            int tileX = centerX - 64;
            int tileY = this.topButtons.getBottomY() + 12;
            MultiBufferSource.BufferSource buffers = graphics.bufferSource();
            this.drawMapTile(graphics, buffers, tileX, tileY);
            this.leftButtons.layoutVertical(tileX - ((Button)((Object)this.leftButtons.get(0))).getWidth() - 6, tileY + 6, true, 6);
            this.leftChecks.setHeights(((Button)((Object)this.leftButtons.get(0))).getHeight());
            this.leftChecks.setWidths(15);
            this.leftChecks.layoutVertical(this.leftButtons.getLeftX() - this.checkDay.getWidth(), this.leftButtons.getTopY(), true, 6);
            int bottomY = Math.min(tileY + 128 + 12, this.height - 10 - this.buttonClose.getHeight());
            this.bottomButtons.equalizeWidths(this.getFontRenderer(), 6, ((Button)((Object)this.topButtons.get(0))).getRightX() - topRowLeft);
            this.bottomButtons.layoutCenteredHorizontal(centerX, bottomY, true, 6);
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.layoutButtons: " + LogFormatter.toString(t));
        }
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float par3) {
        try {
            this.renderBackground(graphics, x, y, par3);
            this.renderBottomBar(graphics);
            this.layoutButtons(graphics);
            for (int k = 0; k < this.getRenderables().size(); ++k) {
                net.minecraft.client.gui.components.Button guibutton = (net.minecraft.client.gui.components.Button)this.getRenderables().get(k);
                guibutton.render(graphics, x, y, 0.0f);
            }
            this.drawTitle(graphics);
            this.drawLogo(graphics);
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.render: " + LogFormatter.toString(t));
        }
    }

    protected void drawColorPicker(GuiGraphics graphics, int x, int y, float size) {
        int sizeI = (int)size;
        graphics.fill(x - 1, y - 1, x + sizeI + 1, y + sizeI + 1, -6250336);
        float scale = size / (float)((TextureAccess)this.colorPickTexture).journeymap$getWidth();
        this.colorPickRect.setRect(x, y, size, size);
        DrawUtil.drawImage(graphics.pose(), this.colorPickTexture, x, y, false, scale, 0.0);
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        int colorX = activeSpec.getColorX();
        int colorY = activeSpec.getColorY();
        if (colorX > 0 && colorY > 0) {
            DrawUtil.drawRectangle(graphics, (colorX += x) - 2, (colorY += y) - 2, 5.0, 5.0, Color.darkGray.getRGB(), 0.8f);
            DrawUtil.drawRectangle(graphics, colorX - 1, colorY, 3.0, 1.0, this.activeColor, 1.0f);
            DrawUtil.drawRectangle(graphics, colorX, colorY - 1, 1.0, 3.0, this.activeColor, 1.0f);
        }
    }

    protected void drawMapTile(GuiGraphics graphics, MultiBufferSource.BufferSource buffers, int x, int y) {
        float scale = 1.0f;
        graphics.fill(x - 1, y - 1, x + 128 + 1, y + 128 + 1, -6250336);
        DynamicTexture tileTex = this.getTileSample(this.activeMapType);
        DrawUtil.drawImage(graphics.pose(), tileTex, x, y, false, 1.0f, 0.0);
        if (scale == 2.0f) {
            DrawUtil.drawImage(graphics.pose(), tileTex, x + 128, y, true, 1.0f, 0.0);
            DrawUtil.drawImage(graphics.pose(), tileTex, x, y + 128, true, 1.0f, 180.0);
            DrawUtil.drawImage(graphics.pose(), tileTex, x + 128, y + 128, false, 1.0f, 180.0);
        }
        GridSpec gridSpec = this.gridSpecs.getSpec(this.activeMapType);
        RenderType renderType = gridSpec.getRenderType(512);
        VertexConsumer regionTileBuffer = buffers.getBuffer(renderType);
        DrawUtil.drawQuad(graphics.pose(), regionTileBuffer, gridSpec.getColor(), gridSpec.alpha, x, y, 128.0, 128.0, 0.0, 0.0, 0.25, 0.25, 0.0, false);
        buffers.endBatch(renderType);
    }

    protected void drawLabel(GuiGraphics graphics, String label, int x, int y) {
        graphics.drawString(this.getFontRenderer(), label, x, y, Color.cyan.getRGB());
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        try {
            switch (keyCode) {
                case 256: {
                    this.closeAndReturn();
                    return true;
                }
                case 257: {
                    this.saveAndClose();
                    return true;
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.keyTyped: " + LogFormatter.toString(t));
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        try {
            if (this.buttonOpacity.dragging) {
                this.updateGridSpecs();
            } else {
                this.checkColorPicker(mouseX, mouseY);
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.mouseClickMove: " + LogFormatter.toString(t));
        }
        return super.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        try {
            super.mouseClicked(mouseX, mouseY, mouseButton);
            if (mouseButton == 0) {
                this.checkColorPicker(mouseX, mouseY);
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.mouseClicked: " + LogFormatter.toString(t));
        }
        return true;
    }

    protected void checkColorPicker(double mouseX, double mouseY) {
        if (this.colorPickRect.contains(mouseX, mouseY)) {
            int x = (int)(mouseX - (double)((int)this.colorPickRect.x));
            int y = (int)(mouseY - (double)((int)this.colorPickRect.y));
            int rgb = this.colorPickTexture.getPixels().getPixelRGBA(x, y);
            this.activeColor = RGB.rgbaToRgb(rgb);
            GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
            activeSpec.setColorCoords(x, y);
            this.updateGridSpecs();
        }
    }

    protected void updatePreview(MapType mapType) {
        this.activeMapType = mapType;
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        this.activeColor = activeSpec.getColor();
        this.buttonOpacity.setValue(activeSpec.alpha);
        this.buttonStyle.setValue(activeSpec.style);
        this.checkDay.setToggled(mapType.isDay());
        this.checkNight.setToggled(mapType.isNight());
        this.checkUnderground.setToggled(mapType.isUnderground());
        this.buttonDay.setToggled(mapType.isDay());
        this.buttonNight.setToggled(mapType.isNight());
        this.buttonUnderground.setToggled(mapType.isUnderground());
    }

    protected void updateGridSpecs() {
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        int colorX = activeSpec.getColorX();
        int colorY = activeSpec.getColorY();
        GridSpec newSpec = new GridSpec(this.buttonStyle.getField().get(), new Color(this.activeColor), this.buttonOpacity.getValue()).setColorCoords(colorX, colorY);
        if (this.checkDay.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.day((ResourceKey<Level>)Level.OVERWORLD), newSpec);
        }
        if (this.checkNight.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.night((ResourceKey<Level>)Level.OVERWORLD), newSpec);
        }
        if (this.checkUnderground.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.underground(0, (ResourceKey<Level>)Level.OVERWORLD), newSpec);
        }
    }

    protected void saveAndClose() {
        this.updateGridSpecs();
        JourneymapClient.getInstance().getCoreProperties().gridSpecs.updateFrom(this.gridSpecs);
        JourneymapClient.getInstance().getCoreProperties().save();
        this.closeAndReturn();
    }

    protected void resetGridSpecs() {
        if (this.checkDay.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.day((ResourceKey<Level>)Level.OVERWORLD), GridSpecs.DEFAULT_DAY.clone());
        }
        if (this.checkNight.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.night((ResourceKey<Level>)Level.OVERWORLD), GridSpecs.DEFAULT_NIGHT.clone());
        }
        if (this.checkUnderground.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.underground(0, (ResourceKey<Level>)Level.OVERWORLD), GridSpecs.DEFAULT_UNDERGROUND.clone());
        }
        this.children().clear();
        this.getRenderables().clear();
        this.init();
    }

    public DynamicTexture getTileSample(MapType mapType) {
        if (mapType.isNight()) {
            return TextureCache.getTexture(TextureCache.TileSampleNight);
        }
        if (mapType.isUnderground()) {
            return TextureCache.getTexture(TextureCache.TileSampleUnderground);
        }
        return TextureCache.getTexture(TextureCache.TileSampleDay);
    }

    @Override
    protected void renderBottomBar(GuiGraphics graphics) {
        DrawUtil.drawRectangle(graphics, 0.0, this.height - 30, this.width, this.height, 0, 0.6f);
    }
}

