/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.dropdown;

import com.mojang.blaze3d.platform.Window;
import java.util.List;
import java.util.Optional;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.Removable;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.ImageDropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import journeymap.client.ui.component.screens.ScrollPaneScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;

public class DropDownButton
extends Button
implements Removable,
SelectableParent {
    private static final int MAX_DISPLAY_SIZE = 6;
    protected boolean visible = false;
    protected DropDownItem selected;
    protected List<DropDownItem> items;
    protected int paneWidth;
    protected Button.OnPress onPress;
    protected int rotation = 0;
    protected DynamicTexture glyphIcon = TextureCache.getTexture(TextureCache.ARROW_GLYPH);
    protected int panelMargin = 2;
    protected ScrollPaneScreen paneScreen;
    protected int buttonBuffer = 50;
    protected int hgap = 5;
    protected boolean scaleButtonWidth = true;
    protected boolean renderSolidBackground = false;

    public DropDownButton(String label, Button.OnPress onPress) {
        super(label, DropDownButton.emptyPressable());
        this.onPress = onPress;
    }

    public void setItems(List<DropDownItem> items) {
        this.items = items;
        this.paneWidth = this.getWidth();
        this.paneScreen = new ScrollPaneScreen(this, items, this.paneWidth, this.getPaneHeight(), this.getX(), this.getPanelLocation());
        this.paneScreen.setRenderSolidBackground(this.renderSolidBackground);
    }

    public void setRenderSolidBackground(boolean value) {
        this.renderSolidBackground = value;
        if (this.paneScreen != null) {
            this.paneScreen.setRenderSolidBackground(value);
        }
    }

    public void setRenderDecorations(boolean value) {
        this.paneScreen.setRenderDecorations(value);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean buttonClicked = super.mouseClicked(mouseX, mouseY, button);
        if (buttonClicked && !this.visible) {
            this.openDropDown();
            return true;
        }
        return buttonClicked;
    }

    protected void openDropDown() {
        if (!this.visible) {
            this.visible = true;
            this.setEnabled(false);
            this.paneScreen.setPaneX(this.getX());
            this.paneScreen.setPaneY(this.getPanelLocation());
            this.paneScreen.display();
        }
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        int imageX = this.getX() + 5;
        if (this.horizontalAlignment == DrawUtil.HAlign.Left) {
            imageX = this.getRightX() - this.WIDTH_PAD / 2 - this.fontRenderer.width(this.getMessage().getString()) - 10;
        }
        DrawUtil.drawClampedImage(graphics.pose(), this.glyphIcon, this.getLabelColor(), this.visible ? 0.8f : 1.0f, imageX, (float)this.getMiddleY() - (float)((TextureAccess)this.glyphIcon).journeymap$getHeight() * 0.25f / 2.0f, 0.25f, this.visible ? (double)this.rotation : 0.0);
        DropDownItem dropDownItem = this.selected;
        if (dropDownItem instanceof ImageDropDownItem) {
            ImageDropDownItem item = (ImageDropDownItem)dropDownItem;
            item.renderImage(graphics, this.getCenterX(), this.getY() + (this.height >> 1) - (item.getHeight() >> 1));
        }
    }

    protected int getPanelLocation() {
        Window window = Minecraft.getInstance().getWindow();
        int panelHeight = this.getPaneHeight();
        int windowBottom = window.getGuiScaledHeight();
        if (super.getY() - (this.panelMargin + panelHeight) <= 0) {
            this.rotation = 90;
            return super.getY() + this.panelMargin + this.height;
        }
        if (super.getY() + (this.panelMargin + panelHeight) > windowBottom) {
            this.rotation = -90;
            return super.getY() - panelHeight - this.panelMargin;
        }
        this.rotation = 90;
        return super.getY() + this.panelMargin + this.height;
    }

    protected int getPaneHeight() {
        int size = Math.min(this.items.size(), 6);
        return size * (this.items.get(0).getHeight() + 5);
    }

    @Override
    public void onRemove() {
        this.visible = false;
        this.setEnabled(true);
    }

    public int getWidth() {
        int width = 0;
        if (this.items != null) {
            Font fontRenderer = Minecraft.getInstance().font;
            for (DropDownItem item : this.items) {
                width = Math.max(width, fontRenderer.width(this.getLabel(item)));
            }
            if (!this.scaleButtonWidth) {
                return width + this.buttonBuffer;
            }
            this.width = width + this.buttonBuffer;
        }
        return this.width;
    }

    public int getHeight() {
        int height = 0;
        if (this.items != null) {
            for (DropDownItem item : this.items) {
                height = Math.max(height, item.getHeight());
            }
            this.height = height + this.hgap;
        }
        return this.height;
    }

    protected String getLabel(DropDownItem item) {
        return item.getLabel();
    }

    @Override
    public void setSelected(DropDownItem selected) {
        this.selected = selected;
        this.onPress.onPress((net.minecraft.client.gui.components.Button)selected);
        this.setMessage((Component)Component.literal((String)selected.getLabel()));
    }

    public void setSelectedId(String id) {
        Optional<DropDownItem> select = this.items.stream().filter(item -> item.getId().toString().equals(id)).findFirst();
        if (select.isPresent()) {
            this.selected = select.get();
            this.setMessage((Component)Component.literal((String)this.selected.getLabel()));
        }
    }

    public DropDownItem getSelected() {
        return this.selected;
    }

    protected String getSelectedLabel() {
        return this.getLabel(this.selected);
    }

    public void setButtonBuffer(int buttonBuffer) {
        this.buttonBuffer = buttonBuffer;
    }
}

