/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.common.properties.config.StringField;

public class RegionTileShaders
implements StringField.ValuesProvider {
    public static final List<String> REGION_SHADERS = List.of("default", "grayscale", "sepia_1", "sepia_2", "sepia_3");
    private static final Map<String, ShaderKeys> idMap = new HashMap<String, ShaderKeys>();
    private static final Map<String, ShaderKeys> keyMap = new HashMap<String, ShaderKeys>();
    private static final Int2ObjectOpenHashMap<ShaderKeys> indexMap = new Int2ObjectOpenHashMap();

    public static int from(String key) {
        return RegionTileShaders.keyMap.get((Object)key).index;
    }

    public static String from(int key) {
        return ((ShaderKeys)indexMap.get(key)).id();
    }

    @Override
    public List<String> getStrings() {
        return REGION_SHADERS.stream().map(value -> idMap.get(value).name()).toList();
    }

    @Override
    public String getDefaultString() {
        return idMap.get(REGION_SHADERS.getFirst()).name();
    }

    @Override
    public String getTooltip(String value) {
        return keyMap.get(value).tooltip();
    }

    static {
        int index = 1;
        for (String id : REGION_SHADERS) {
            ShaderKeys shader = new ShaderKeys(id, index);
            idMap.put(id, shader);
            keyMap.put(shader.key(), shader);
            indexMap.put(index, (Object)shader);
            ++index;
        }
    }

    public record ShaderKeys(String id, int index) {
        public String key() {
            return String.format("jm.common.map_filter.%s", this.id());
        }

        public String name() {
            return Constants.getString("jm.common.map_filter.%s", this.id());
        }

        public String tooltip() {
            return Constants.getString("jm.common.map_filter.%s.tooltip", this.id());
        }
    }
}

