/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.neoforge.cobalt.registration;

import immersive_aircraft.cobalt.registration.Registration;
import immersive_aircraft.neoforge.NeoForgeBusEvents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RegistrationImpl
extends Registration.Impl {
    private final Map<String, RegistryRepo> repos = new HashMap<String, RegistryRepo>();
    private final DataLoaderRegister dataLoaderRegister = new DataLoaderRegister();
    private final DataLoaderRegister resourceLoaderRegister = new DataLoaderRegister();
    private final IEventBus modBus;

    public RegistrationImpl(IEventBus modBus) {
        NeoForgeBusEvents.DATA_REGISTRY = this.dataLoaderRegister;
        NeoForgeBusEvents.RESOURCE_REGISTRY = this.resourceLoaderRegister;
        this.modBus = modBus;
    }

    private RegistryRepo getRepo(String namespace) {
        return this.repos.computeIfAbsent(namespace, x$0 -> new RegistryRepo((String)x$0));
    }

    @Override
    public <T extends Entity> void registerEntityRenderer(EntityType<T> type, EntityRendererProvider<T> constructor) {
        EntityRenderers.register(type, constructor);
    }

    @Override
    public void registerDataLoader(ResourceLocation id, PreparableReloadListener loader) {
        this.dataLoaderRegister.dataLoaders.add(loader);
    }

    @Override
    public void registerResourceLoader(ResourceLocation id, PreparableReloadListener loader) {
        this.resourceLoaderRegister.dataLoaders.add(loader);
    }

    @Override
    public <T> Supplier<T> register(Registry<? super T> registry, ResourceLocation id, Supplier<T> obj) {
        DeferredRegister reg = this.getRepo(id.getNamespace()).get(registry);
        return reg.register(id.getPath(), obj);
    }

    public static class DataLoaderRegister {
        private final List<PreparableReloadListener> dataLoaders = new ArrayList<PreparableReloadListener>();

        public List<PreparableReloadListener> getLoaders() {
            return this.dataLoaders;
        }
    }

    class RegistryRepo {
        private final Set<ResourceLocation> skipped = new HashSet<ResourceLocation>();
        private final Map<ResourceLocation, DeferredRegister<?>> registries = new HashMap();
        private final String namespace;

        public RegistryRepo(String namespace) {
            this.namespace = namespace;
        }

        public <T> DeferredRegister get(Registry<? super T> registry) {
            ResourceLocation id = registry.key().location();
            if (!this.registries.containsKey(id) && !this.skipped.contains(id)) {
                DeferredRegister def = DeferredRegister.create(registry, (String)this.namespace);
                def.register(RegistrationImpl.this.modBus);
                this.registries.put(id, def);
            }
            return this.registries.get(id);
        }
    }
}

