/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import com.mojang.math.Axis;
import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.item.upgrade.VehicleStat;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class AirshipEntity
extends Rotorcraft {
    private final List<Trail> trails = List.of(new Trail(15, 0.5f));

    public AirshipEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, true);
    }

    @Override
    protected float getEngineReactionSpeed() {
        return 50.0f;
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.PROPELLER_SMALL.get();
    }

    @Override
    public Item asItem() {
        return Items.AIRSHIP.get();
    }

    @Override
    public List<Trail> getTrails() {
        return this.trails;
    }

    void trail(Matrix4f transform) {
        this.trail(transform, 0);
    }

    void trail(Matrix4f transform, int index) {
        this.trail(transform, index, 0.15f);
    }

    void trail(Matrix4f transform, int index, float thickness) {
        Vector4f p0 = this.transformPosition(transform, -thickness, 0.0f, 0.0f);
        Vector4f p1 = this.transformPosition(transform, thickness, 0.0f, 0.0f);
        float trailStrength = Math.max(0.0f, Math.min(1.0f, (float)(this.getDeltaMovement().length() - (double)0.05f)));
        this.getTrails().get(index).add(p0, p1, trailStrength);
    }

    @Override
    protected double getDefaultGravity() {
        return this.wasTouchingWater ? (double)-0.04f : (double)(1.0f - this.getEnginePower()) * super.getDefaultGravity();
    }

    @Override
    protected void updateController() {
        super.updateController();
        if (this.canTurnOnEngine((Entity)this.getControllingPassenger())) {
            this.setEngineTarget(1.0f);
        }
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(this.getEnginePower() * this.getProperties().get(VehicleStat.VERTICAL_SPEED) * this.pressingInterpolatedY.getSmooth()), 0.0));
        Vector3f direction = this.getForwardDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 5.0) * (double)this.getProperties().get(VehicleStat.ENGINE_SPEED)) * this.pressingInterpolatedZ.getSmooth();
        Vector3f f = direction.mul(thrust);
        this.setDeltaMovement(this.getDeltaMovement().add((double)f.x, (double)f.y, (double)f.z));
    }

    @Override
    public void tick() {
        super.tick();
        float power = this.getEnginePower();
        if (this.level().isClientSide) {
            if (this.isWithinParticleRange() && (double)power > 0.01) {
                Matrix4f transform = this.getVehicleTransform();
                this.addTrails(transform);
                if (this.tickCount % 2 == 0) {
                    Vector4f p = this.transformPosition(transform, (this.random.nextFloat() - 0.5f) * 0.4f, 0.8f, -0.8f);
                    Vec3 velocity = this.getDeltaMovement();
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)p.x, (double)p.y, (double)p.z, velocity.x, velocity.y, velocity.z);
                }
            } else {
                this.trails.get(0).add(ZERO_VEC4, ZERO_VEC4, 0.0f);
            }
        }
    }

    protected void addTrails(Matrix4f transform) {
        Matrix4f tr = new Matrix4f((Matrix4fc)transform);
        tr.translate((Vector3fc)new Vector3f(0.0f, 0.4f, -1.2f));
        tr.rotate((Quaternionfc)Axis.ZP.rotationDegrees(this.engineRotation.getSmooth() * 50.0f));
        this.trail(tr);
    }

    @Override
    public double getZoom() {
        return 5.0;
    }

    @Override
    public float getPropellerSpeed() {
        return super.getPropellerSpeed() * (0.25f + Math.abs(this.pressingInterpolatedZ.get(0.0f)));
    }
}

