/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client;

import com.mojang.blaze3d.systems.RenderSystem;
import immersive_aircraft.Main;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.EngineVehicle;
import immersive_aircraft.entity.VehicleEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class OverlayRenderer {
    static final OverlayRenderer INSTANCE = new OverlayRenderer();
    private static final ResourceLocation ENGINE_TEX = Main.locate("textures/gui/engine.png");
    private static final ResourceLocation POWER_TEX = Main.locate("textures/gui/power.png");
    private static final ResourceLocation ICONS_TEX = Main.locate("textures/gui/icons.png");
    private float bootUp = 0.0f;
    private float lastTime = 0.0f;

    public static int renderOverlay(GuiGraphics context, float tickDelta, int barHeightOffset) {
        Minecraft client = Minecraft.getInstance();
        if (client.gameMode != null && client.player != null) {
            Entity entity;
            if (Config.getInstance().showHotbarEngineGauge && (entity = client.player.getRootVehicle()) instanceof EngineVehicle) {
                EngineVehicle aircraft = (EngineVehicle)entity;
                INSTANCE.renderAircraftGui(client, context, tickDelta, aircraft);
            }
            if ((entity = client.player.getRootVehicle()) instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)entity;
                INSTANCE.renderAircraftHealth(client, context, vehicle, barHeightOffset);
                return 10;
            }
        }
        return 0;
    }

    private void renderAircraftHealth(Minecraft minecraft, GuiGraphics context, VehicleEntity vehicle, int barHeightOffset) {
        int screenWidth = minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = minecraft.getWindow().getGuiScaledHeight();
        int maxHearts = 10;
        int health = (int)Math.ceil(vehicle.getHealth() * (float)maxHearts * 2.0f);
        int y = screenHeight - barHeightOffset - Config.getInstance().healthBarRow * 10;
        int ox = screenWidth / 2 + 91;
        for (int i = 0; i < maxHearts; ++i) {
            int u = 52;
            int x = ox - i * 8 - 9;
            context.blit(ICONS_TEX, x, y, (float)u, 9.0f, 9, 9, 64, 64);
            if (i * 2 + 1 < health) {
                context.blit(ICONS_TEX, x, y, 0.0f, 0.0f, 9, 9, 64, 64);
            }
            if (i * 2 + 1 != health) continue;
            context.blit(ICONS_TEX, x, y, 10.0f, 0.0f, 9, 9, 64, 64);
        }
    }

    private void renderAircraftGui(Minecraft client, GuiGraphics context, float tickDelta, EngineVehicle aircraft) {
        assert (client.level != null);
        if (aircraft.getGuiStyle() == EngineVehicle.GUI_STYLE.ENGINE) {
            int frame;
            float time = (float)(client.level.getGameTime() % 65536L) + tickDelta;
            float delta = time - this.lastTime;
            this.lastTime = time;
            if (aircraft.getEngineTarget() > 0.0f && (double)aircraft.getEnginePower() > 0.001) {
                if (this.bootUp < 1.0f) {
                    this.bootUp = Math.min(1.0f, this.bootUp + delta * 0.2f);
                    frame = (int)(this.bootUp * 5.0f);
                } else {
                    int FPS = 30;
                    int animation = (int)(aircraft.engineRotation.getSmooth(tickDelta) / 20.0f * 30.0f);
                    frame = 5 + animation % 6;
                }
            } else if (this.bootUp > 0.0f) {
                this.bootUp = Math.max(0.0f, this.bootUp - delta * 0.1f);
                frame = 10 + (int)((1.0 - (double)this.bootUp) * 10.0);
            } else {
                frame = 20;
            }
            int powerFrame = (int)((double)((1.0f - aircraft.getEnginePower()) * 10.0f) + 10.5);
            int powerFrameTarget = (int)((double)((1.0f - aircraft.getEngineTarget()) * 10.0f) + 10.5);
            int x = client.getWindow().getGuiScaledWidth() / 2;
            int y = client.getWindow().getGuiScaledHeight() - 37;
            if (client.gameMode != null && !client.gameMode.hasExperience()) {
                y += 7;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.blit(ENGINE_TEX, x - 9, y - 9, (float)(frame % 5 * 18), (float)(Math.floorDiv(frame, 5) * 18), 18, 18, 90, 90);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            context.blit(POWER_TEX, x - 9, y - 9, (float)(powerFrame % 5 * 18), (float)(Math.floorDiv(powerFrame, 5) * 18), 18, 18, 90, 90);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            context.blit(POWER_TEX, x - 9, y - 9, (float)(powerFrameTarget % 5 * 18), (float)(Math.floorDiv(powerFrameTarget, 5) * 18), 18, 18, 90, 90);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

