/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.hotkettles.neoforge;

import com.matthewperiut.hotkettles.HotKettles;
import com.matthewperiut.hotkettles.HotKettlesClient;
import com.matthewperiut.hotkettles.block.HotKettleBlocks;
import com.matthewperiut.hotkettles.blockentity.KettleBlockEntity;
import com.matthewperiut.hotkettles.client.render.blockentity.KettleBlockEntityRenderer;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="hotkettles")
public class HotKettlesNeoForge {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"hotkettles");
    public static final Supplier<BlockEntityType<KettleBlockEntity>> KETTLE_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("kettle", () -> BlockEntityType.Builder.of(KettleBlockEntity::new, (Block[])new Block[]{(Block)HotKettleBlocks.KETTLE.get()}).build(null));

    public HotKettlesNeoForge(IEventBus modEventBus) {
        HotKettles.init();
        BLOCK_ENTITY_TYPES.register(modEventBus);
    }

    @EventBusSubscriber(modid="hotkettles", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(KETTLE_BLOCK_ENTITY_TYPE.get(), KettleBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            HotKettlesClient.init();
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.KETTLE.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.EMPTY_MUG.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.APPLE_CIDER.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.BITTER_WATER.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.CUP_OF_MILK.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.POISON.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.CUP_OF_WATER.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.CUP_OF_LAVA.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.HOT_CHOCOLATE.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.LATTE.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.MOCHA.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.PUMPKIN_SPICE_LATTE.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.DANDELION_TEA.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.ROSE_TEA.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)HotKettleBlocks.FAIRY_TEA.get()});
        }
    }
}

