/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.hotkettles.item;

import com.matthewperiut.hotkettles.block.KettleBlock;
import com.matthewperiut.hotkettles.blockentity.KettleBlockEntity;
import com.matthewperiut.hotkettles.components.HotKettleComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public class KettleItem
extends BlockItem {
    public int kettle_type = 0;

    public KettleItem(Block block, Item.Properties settings, int kettle_type) {
        super(block, settings.stacksTo(1));
        this.kettle_type = kettle_type;
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)("block." + BuiltInRegistries.ITEM.getKey((Object)this).toString().replace(":", ".")));
    }

    public InteractionResult place(BlockPlaceContext context) {
        InteractionResult result = super.place(context);
        if (result == InteractionResult.CONSUME) {
            if (context.getItemInHand().has((DataComponentType)HotKettleComponents.LIQUID_LEVEL_COMPONENT.get())) {
                int liquidLevel = (Integer)context.getItemInHand().get((DataComponentType)HotKettleComponents.LIQUID_LEVEL_COMPONENT.get());
                ((KettleBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos())).setLiquidLevel(liquidLevel);
            } else if ((Integer)context.getLevel().getBlockState(context.getClickedPos()).getValue((Property)KettleBlock.KETTLE_TYPE) == 0) {
                ((KettleBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos())).setLiquidLevel(0);
            } else {
                ((KettleBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos())).setLiquidLevel(5);
            }
        }
        return result;
    }

    public int getBarWidth(ItemStack stack) {
        if (stack.has((DataComponentType)HotKettleComponents.LIQUID_LEVEL_COMPONENT.get())) {
            int liquidLevel = (Integer)stack.get((DataComponentType)HotKettleComponents.LIQUID_LEVEL_COMPONENT.get());
            int result = (int)((float)liquidLevel * 2.6f);
            return result;
        }
        return 13;
    }

    public int getBarColor(ItemStack stack) {
        return 65280;
    }

    public boolean isBarVisible(ItemStack stack) {
        if (stack.has((DataComponentType)HotKettleComponents.LIQUID_LEVEL_COMPONENT.get())) {
            int liquidLevel = (Integer)stack.get((DataComponentType)HotKettleComponents.LIQUID_LEVEL_COMPONENT.get());
            return liquidLevel != 5;
        }
        return false;
    }
}

