/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util;

import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefBuilder;
import guideme.internal.shaded.lucene.util.Counter;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import java.util.Arrays;

public final class ByteBlockPool
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(ByteBlockPool.class);
    public static final int BYTE_BLOCK_SHIFT = 15;
    public static final int BYTE_BLOCK_SIZE = 32768;
    public static final int BYTE_BLOCK_MASK = Short.MAX_VALUE;
    private byte[][] buffers = new byte[10][];
    private int bufferUpto = -1;
    public int byteUpto = 32768;
    public byte[] buffer;
    public int byteOffset = Short.MIN_VALUE;
    private final Allocator allocator;

    public ByteBlockPool(Allocator allocator) {
        this.allocator = allocator;
    }

    public void reset(boolean zeroFillBuffers, boolean reuseFirst) {
        if (this.bufferUpto != -1) {
            if (zeroFillBuffers) {
                for (int i = 0; i < this.bufferUpto; ++i) {
                    Arrays.fill(this.buffers[i], (byte)0);
                }
                Arrays.fill(this.buffers[this.bufferUpto], 0, this.byteUpto, (byte)0);
            }
            if (this.bufferUpto > 0 || !reuseFirst) {
                int offset = reuseFirst ? 1 : 0;
                this.allocator.recycleByteBlocks(this.buffers, offset, 1 + this.bufferUpto);
                Arrays.fill((Object[])this.buffers, offset, 1 + this.bufferUpto, null);
            }
            if (reuseFirst) {
                this.bufferUpto = 0;
                this.byteUpto = 0;
                this.byteOffset = 0;
                this.buffer = this.buffers[0];
            } else {
                this.bufferUpto = -1;
                this.byteUpto = 32768;
                this.byteOffset = Short.MIN_VALUE;
                this.buffer = null;
            }
        }
    }

    public void nextBuffer() {
        if (1 + this.bufferUpto == this.buffers.length) {
            byte[][] newBuffers = new byte[ArrayUtil.oversize(this.buffers.length + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            this.buffers = newBuffers;
        }
        byte[] byArray = this.allocator.getByteBlock();
        this.buffers[1 + this.bufferUpto] = byArray;
        this.buffer = byArray;
        ++this.bufferUpto;
        this.byteUpto = 0;
        this.byteOffset = Math.addExact(this.byteOffset, 32768);
    }

    void setBytesRef(BytesRefBuilder builder, BytesRef result, long offset, int length) {
        result.length = length;
        int bufferIndex = Math.toIntExact(offset >> 15);
        byte[] buffer = this.buffers[bufferIndex];
        int pos = (int)(offset & 0x7FFFL);
        if (pos + length <= 32768) {
            result.bytes = buffer;
            result.offset = pos;
        } else {
            builder.growNoCopy(length);
            result.bytes = builder.get().bytes;
            result.offset = 0;
            this.readBytes(offset, result.bytes, 0, length);
        }
    }

    public void append(BytesRef bytes) {
        this.append(bytes.bytes, bytes.offset, bytes.length);
    }

    public void append(ByteBlockPool srcPool, long srcOffset, int length) {
        int bytesLeft = length;
        while (bytesLeft > 0) {
            int bufferLeft = 32768 - this.byteUpto;
            if (bytesLeft < bufferLeft) {
                this.appendBytesSingleBuffer(srcPool, srcOffset, bytesLeft);
                break;
            }
            if (bufferLeft > 0) {
                this.appendBytesSingleBuffer(srcPool, srcOffset, bufferLeft);
                bytesLeft -= bufferLeft;
                srcOffset += (long)bufferLeft;
            }
            this.nextBuffer();
        }
    }

    private void appendBytesSingleBuffer(ByteBlockPool srcPool, long srcOffset, int length) {
        assert (length <= 32768 - this.byteUpto);
        while (length > 0) {
            byte[] srcBytes = srcPool.buffers[Math.toIntExact(srcOffset >> 15)];
            int srcPos = Math.toIntExact(srcOffset & 0x7FFFL);
            int bytesToCopy = Math.min(length, 32768 - srcPos);
            System.arraycopy(srcBytes, srcPos, this.buffer, this.byteUpto, bytesToCopy);
            length -= bytesToCopy;
            srcOffset += (long)bytesToCopy;
            this.byteUpto += bytesToCopy;
        }
    }

    public void append(byte[] bytes) {
        this.append(bytes, 0, bytes.length);
    }

    public void append(byte[] bytes, int offset, int length) {
        int bytesLeft = length;
        while (bytesLeft > 0) {
            int bufferLeft = 32768 - this.byteUpto;
            if (bytesLeft < bufferLeft) {
                System.arraycopy(bytes, offset, this.buffer, this.byteUpto, bytesLeft);
                this.byteUpto += bytesLeft;
                break;
            }
            if (bufferLeft > 0) {
                System.arraycopy(bytes, offset, this.buffer, this.byteUpto, bufferLeft);
            }
            this.nextBuffer();
            bytesLeft -= bufferLeft;
            offset += bufferLeft;
        }
    }

    public void readBytes(long offset, byte[] bytes, int bytesOffset, int bytesLength) {
        int chunk;
        int bufferIndex = Math.toIntExact(offset >> 15);
        int pos = (int)(offset & 0x7FFFL);
        for (int bytesLeft = bytesLength; bytesLeft > 0; bytesLeft -= chunk) {
            byte[] buffer = this.buffers[bufferIndex++];
            assert (buffer != null);
            chunk = Math.min(bytesLeft, 32768 - pos);
            System.arraycopy(buffer, pos, bytes, bytesOffset, chunk);
            bytesOffset += chunk;
            pos = 0;
        }
    }

    public byte readByte(long offset) {
        int bufferIndex = (int)(offset >> 15);
        int pos = (int)(offset & 0x7FFFL);
        return this.buffers[bufferIndex][pos];
    }

    @Override
    public long ramBytesUsed() {
        long size = BASE_RAM_BYTES;
        size += RamUsageEstimator.shallowSizeOf((Object[])this.buffers);
        for (byte[] buf : this.buffers) {
            size += RamUsageEstimator.sizeOfObject(buf);
        }
        return size;
    }

    public long getPosition() {
        return this.bufferUpto * this.allocator.blockSize + this.byteUpto;
    }

    public byte[] getBuffer(int bufferIndex) {
        return this.buffers[bufferIndex];
    }

    public static abstract class Allocator {
        protected final int blockSize;

        protected Allocator(int blockSize) {
            this.blockSize = blockSize;
        }

        public abstract void recycleByteBlocks(byte[][] var1, int var2, int var3);

        public byte[] getByteBlock() {
            return new byte[this.blockSize];
        }
    }

    public static class DirectTrackingAllocator
    extends Allocator {
        private final Counter bytesUsed;

        public DirectTrackingAllocator(Counter bytesUsed) {
            super(32768);
            this.bytesUsed = bytesUsed;
        }

        @Override
        public byte[] getByteBlock() {
            this.bytesUsed.addAndGet(this.blockSize);
            return new byte[this.blockSize];
        }

        @Override
        public void recycleByteBlocks(byte[][] blocks, int start, int end) {
            this.bytesUsed.addAndGet(-((end - start) * this.blockSize));
            for (int i = start; i < end; ++i) {
                blocks[i] = null;
            }
        }
    }

    public static final class DirectAllocator
    extends Allocator {
        public DirectAllocator() {
            super(32768);
        }

        @Override
        public void recycleByteBlocks(byte[][] blocks, int start, int end) {
        }
    }
}

