/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.Field;
import guideme.internal.shaded.lucene.document.FieldType;
import guideme.internal.shaded.lucene.document.SortedSetDocValuesRangeQuery;
import guideme.internal.shaded.lucene.index.DocValuesSkipIndexType;
import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.search.MultiTermQuery;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.TermInSetQuery;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.util.Collection;

public class SortedSetDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();
    private static final FieldType INDEXED_TYPE;

    public static SortedSetDocValuesField indexedField(String name, BytesRef bytes) {
        return new SortedSetDocValuesField(name, bytes, INDEXED_TYPE);
    }

    public SortedSetDocValuesField(String name, BytesRef bytes) {
        this(name, bytes, TYPE);
    }

    private SortedSetDocValuesField(String name, BytesRef bytes, FieldType fieldType) {
        super(name, fieldType);
        this.fieldsData = bytes;
    }

    public static Query newSlowRangeQuery(String field, BytesRef lowerValue, BytesRef upperValue, boolean lowerInclusive, boolean upperInclusive) {
        return new SortedSetDocValuesRangeQuery(field, lowerValue, upperValue, lowerInclusive, upperInclusive);
    }

    public static Query newSlowExactQuery(String field, BytesRef value) {
        return SortedSetDocValuesField.newSlowRangeQuery(field, value, value, true, true);
    }

    public static Query newSlowSetQuery(String field, Collection<BytesRef> values) {
        return new TermInSetQuery(MultiTermQuery.DOC_VALUES_REWRITE, field, values);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_SET);
        TYPE.freeze();
        INDEXED_TYPE = new FieldType(TYPE);
        INDEXED_TYPE.setDocValuesSkipIndexType(DocValuesSkipIndexType.RANGE);
        INDEXED_TYPE.freeze();
    }
}

