/*
 * Decompiled with CFR 0.152.
 */
package guideme.layout;

import guideme.document.LytRect;
import guideme.document.block.AlignItems;
import guideme.document.block.LytAxis;
import guideme.document.block.LytBlock;
import guideme.layout.LayoutContext;
import java.util.List;
import org.joml.Vector2i;

public final class Layouts {
    private Layouts() {
    }

    public static LytRect verticalLayout(LayoutContext context, List<LytBlock> children, int x, int y, int availableWidth, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom, int gap, AlignItems alignItems) {
        return Layouts.verticalLayout(context, children, x, y, availableWidth, false, paddingLeft, paddingTop, paddingRight, paddingBottom, gap, alignItems);
    }

    public static LytRect verticalLayout(LayoutContext context, List<LytBlock> children, int x, int y, int availableWidth, boolean fullWidth, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom, int gap, AlignItems alignItems) {
        int innerX = x + paddingLeft;
        int innerY = y + paddingTop;
        int innerWidth = availableWidth - paddingLeft - paddingRight;
        LytBlock previousBlock = null;
        int contentWidth = paddingLeft;
        int contentHeight = paddingTop;
        for (LytBlock child : children) {
            innerY = Layouts.offsetIntoContentArea(LytAxis.VERTICAL, innerY, previousBlock, child);
            int blockWidth = Math.max(1, innerWidth - child.getMarginLeft() - child.getMarginRight());
            LytRect childBounds = child.layout(context, innerX + child.getMarginLeft(), innerY, blockWidth);
            innerY += childBounds.height() + child.getMarginBottom() + gap;
            contentWidth = Math.max(contentWidth, childBounds.right() - x);
            contentHeight = Math.max(contentHeight, childBounds.bottom() - y);
            previousBlock = child;
        }
        if (fullWidth) {
            contentWidth = availableWidth;
        }
        Layouts.alignChildren(LytAxis.HORIZONTAL, children, alignItems, x + paddingLeft, x + contentWidth);
        return new LytRect(x, y, contentWidth + paddingRight, contentHeight + paddingBottom);
    }

    public static LytRect horizontalLayout(LayoutContext context, List<LytBlock> children, int x, int y, int availableWidth, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom, int gap, AlignItems alignItems) {
        return Layouts.horizontalLayout(context, children, x, y, availableWidth, false, paddingLeft, paddingTop, paddingRight, paddingBottom, gap, alignItems);
    }

    public static LytRect horizontalLayout(LayoutContext context, List<LytBlock> children, int x, int y, int availableWidth, boolean fullWidth, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom, int gap, AlignItems alignItems) {
        int innerX = x + paddingLeft;
        int innerY = y + paddingTop;
        int innerWidth = availableWidth - paddingLeft - paddingRight;
        LytBlock previousBlock = null;
        int contentWidth = paddingLeft;
        int contentHeight = paddingTop;
        for (LytBlock child : children) {
            innerX = Layouts.offsetIntoContentArea(LytAxis.HORIZONTAL, innerX, previousBlock, child);
            int blockWidth = Math.max(1, innerWidth - contentWidth - child.getMarginLeft() - child.getMarginRight());
            LytRect childBounds = child.layout(context, innerX, innerY + child.getMarginTop(), blockWidth);
            contentWidth = Math.max(contentWidth, childBounds.right() - x);
            contentHeight = Math.max(contentHeight, childBounds.bottom() - y);
            previousBlock = child;
            if ((innerX += childBounds.width() + child.getMarginRight() + gap) <= innerWidth) continue;
            innerX = x + paddingLeft;
            innerY = y + contentHeight + gap;
        }
        if (fullWidth) {
            contentWidth = availableWidth;
        }
        Layouts.alignChildren(LytAxis.VERTICAL, children, alignItems, y + paddingTop, y + contentHeight);
        return new LytRect(x, y, contentWidth + paddingRight, contentHeight + paddingBottom);
    }

    private static void alignChildren(LytAxis axis, List<LytBlock> children, AlignItems alignItems, int start, int end) {
        int space = end - start;
        for (LytBlock child : children) {
            LytRect bounds = child.getBounds();
            int childSize = Layouts.size(bounds, axis) + child.getMarginStart(axis) + child.getMarginEnd(axis);
            switch (alignItems) {
                case CENTER: {
                    child.setLayoutPos(Layouts.set(bounds.point(), axis, start + (space - childSize) / 2));
                    break;
                }
                case END: {
                    child.setLayoutPos(Layouts.set(bounds.point(), axis, end - childSize));
                }
            }
        }
    }

    private static Vector2i set(Vector2i point, LytAxis axis, int pos) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case LytAxis.HORIZONTAL -> point.set(pos, point.y);
            case LytAxis.VERTICAL -> point.set(point.x, pos);
        };
    }

    private static int size(LytRect rect, LytAxis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case LytAxis.HORIZONTAL -> rect.width();
            case LytAxis.VERTICAL -> rect.height();
        };
    }

    private static int offsetIntoContentArea(LytAxis axis, int pos, LytBlock previousBlock, LytBlock child) {
        int previousMarginEnd = previousBlock != null ? previousBlock.getMarginEnd(axis) : 0;
        int childMarginStart = child.getMarginStart(axis);
        pos = previousMarginEnd > 0 ? (pos += Math.max(previousMarginEnd, childMarginStart) - previousMarginEnd) : (pos += childMarginStart);
        return pos;
    }
}

