/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block;

import guideme.document.LytRect;
import guideme.document.block.LytAxis;
import guideme.document.block.LytNode;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import guideme.style.BorderStyle;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Vector2i;

public abstract class LytBlock
extends LytNode {
    protected LytRect bounds = LytRect.empty();
    private int marginTop;
    private int marginLeft;
    private int marginRight;
    private int marginBottom;
    private BorderStyle borderTop = BorderStyle.NONE;
    private BorderStyle borderLeft = BorderStyle.NONE;
    private BorderStyle borderRight = BorderStyle.NONE;
    private BorderStyle borderBottom = BorderStyle.NONE;
    private boolean fullWidth;

    @Override
    public LytRect getBounds() {
        return this.bounds;
    }

    public boolean isCulled(LytRect viewport) {
        return !viewport.intersects(this.bounds);
    }

    public final void setLayoutPos(Vector2i point) {
        int deltaX = point.x - this.bounds.x();
        int deltaY = point.y - this.bounds.y();
        if (deltaX != 0 || deltaY != 0) {
            this.bounds = this.bounds.withX(point.x).withY(point.y);
            this.onLayoutMoved(deltaX, deltaY);
        }
    }

    public final LytRect layout(LayoutContext context, int x, int y, int availableWidth) {
        this.bounds = this.computeLayout(context, x, y, availableWidth);
        if (this.fullWidth) {
            this.bounds = this.bounds.withWidth(availableWidth);
        }
        return this.bounds;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public int getMarginStart(LytAxis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case LytAxis.HORIZONTAL -> this.getMarginLeft();
            case LytAxis.VERTICAL -> this.getMarginTop();
        };
    }

    public int getMarginEnd(LytAxis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case LytAxis.HORIZONTAL -> this.getMarginRight();
            case LytAxis.VERTICAL -> this.getMarginBottom();
        };
    }

    public BorderStyle getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(BorderStyle borderTop) {
        this.borderTop = borderTop;
    }

    public BorderStyle getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(BorderStyle borderLeft) {
        this.borderLeft = borderLeft;
    }

    public BorderStyle getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(BorderStyle borderRight) {
        this.borderRight = borderRight;
    }

    public BorderStyle getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(BorderStyle borderBottom) {
        this.borderBottom = borderBottom;
    }

    public void setBorder(BorderStyle style) {
        this.setBorderTop(style);
        this.setBorderLeft(style);
        this.setBorderRight(style);
        this.setBorderBottom(style);
    }

    public boolean isFullWidth() {
        return this.fullWidth;
    }

    public void setFullWidth(boolean fullWidth) {
        this.fullWidth = fullWidth;
    }

    protected abstract LytRect computeLayout(LayoutContext var1, int var2, int var3, int var4);

    protected abstract void onLayoutMoved(int var1, int var2);

    public abstract void renderBatch(RenderContext var1, MultiBufferSource var2);

    public abstract void render(RenderContext var1);
}

