/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion;

import com.google.common.collect.ImmutableSet;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.FusionModelTypeRegistry;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.FusionTextureTypeRegistry;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureData;
import com.supermartijn642.fusion.model.types.connecting.ConnectingBakedModel;
import com.supermartijn642.fusion.predicate.AndConnectionPredicate;
import com.supermartijn642.fusion.predicate.IsFaceVisibleConnectionPredicate;
import com.supermartijn642.fusion.predicate.IsSameBlockConnectionPredicate;
import com.supermartijn642.fusion.predicate.IsSameStateConnectionPredicate;
import com.supermartijn642.fusion.predicate.MatchBlockConnectionPredicate;
import com.supermartijn642.fusion.predicate.MatchStateConnectionPredicate;
import com.supermartijn642.fusion.predicate.NotConnectionPredicate;
import com.supermartijn642.fusion.predicate.OrConnectionPredicate;
import com.supermartijn642.fusion.texture.FusionTextureMetadataSection;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionClient {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fusion");

    public static void init() {
        FusionTextureTypeRegistry.registerTextureType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"vanilla"), DefaultTextureTypes.VANILLA);
        FusionTextureTypeRegistry.registerTextureType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"connecting"), DefaultTextureTypes.CONNECTING);
        FusionTextureTypeRegistry.registerTextureType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"scrolling"), DefaultTextureTypes.SCROLLING);
        FusionModelTypeRegistry.registerModelType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"unknown"), DefaultModelTypes.UNKNOWN);
        FusionModelTypeRegistry.registerModelType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"vanilla"), DefaultModelTypes.VANILLA);
        FusionModelTypeRegistry.registerModelType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"connecting"), DefaultModelTypes.CONNECTING);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"and"), AndConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"or"), OrConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"not"), NotConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"is_face_visible"), IsFaceVisibleConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"is_same_block"), IsSameBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"is_same_state"), IsSameStateConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"match_block"), MatchBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"match_state"), MatchStateConnectionPredicate.SERIALIZER);
        SpriteLoader.DEFAULT_METADATA_SECTIONS = ImmutableSet.builder().addAll((Iterable)SpriteLoader.DEFAULT_METADATA_SECTIONS).add((Object)FusionTextureMetadataSection.INSTANCE).build();
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> InterModComms.sendTo((String)"framedblocks", (String)"add_ct_property", () -> ConnectingBakedModel.SURROUNDING_BLOCK_DATA_MODEL_PROPERTY));
    }

    public static RenderType getRenderTypeMaterial(ConnectingTextureData.RenderType renderType) {
        return switch (renderType) {
            case ConnectingTextureData.RenderType.OPAQUE -> RenderType.solid();
            case ConnectingTextureData.RenderType.CUTOUT -> RenderType.cutout();
            case ConnectingTextureData.RenderType.TRANSLUCENT -> RenderType.translucent();
            default -> throw new AssertionError();
        };
    }
}

