/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.items;

import java.util.List;
import lekavar.lma.drinkbeer.items.BeerBlockItem;
import lekavar.lma.drinkbeer.managers.MixedBeerManager;
import lekavar.lma.drinkbeer.managers.SpiceAndFlavorManager;
import lekavar.lma.drinkbeer.registries.DataComponentTypeRegistry;
import lekavar.lma.drinkbeer.utils.beer.Beers;
import lekavar.lma.drinkbeer.utils.dataComponent.SpiceData;
import lekavar.lma.drinkbeer.utils.mixedbeer.Flavors;
import lekavar.lma.drinkbeer.utils.mixedbeer.Spices;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MixedBeerBlockItem
extends BeerBlockItem {
    public MixedBeerBlockItem(Block block) {
        super(block, new Item.Properties().stacksTo(1).food(new FoodProperties.Builder().alwaysEdible().build()).component(DataComponentTypeRegistry.BEER_ID_COMPONENT, (Object)1).component(DataComponentTypeRegistry.SPICE_COMPONENT, (Object)new SpiceData(0, 0, 0)));
    }

    public void appendMixedBeerTooltip(ItemStack stack, List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)MixedBeerManager.getBaseBeerToolTipTranslationKey()).append(":").setStyle(Style.EMPTY.applyFormat(ChatFormatting.WHITE)));
        int beerId = MixedBeerManager.getBeerId(stack);
        Item beerItem = Beers.byId(beerId).getBeerItem();
        String beerName = beerId > 0 ? "block.drinkbeer." + beerItem.toString() : MixedBeerManager.getUnmixedToolTipTranslationKey();
        String beerTooltip = beerId > 0 ? "item.drinkbeer." + String.valueOf(beerItem) + ".tooltip" : "";
        tooltip.add((Component)Component.translatable((String)beerName).setStyle(Style.EMPTY.applyFormat(ChatFormatting.BLUE)));
        if (beerId > 0 && Beers.byId(beerId).getHasStatusEffectTooltip()) {
            tooltip.add((Component)Component.translatable((String)beerTooltip).setStyle(Style.EMPTY.applyFormat(ChatFormatting.BLUE)));
        }
        if (beerId > 0) {
            String hunger = Integer.toString(beerItem.getFoodProperties(stack, null).nutrition());
            tooltip.add((Component)Component.translatable((String)"drinkbeer.restores_hunger").setStyle(Style.EMPTY.applyFormat(ChatFormatting.BLUE)).append(hunger));
        }
        tooltip.add((Component)Component.translatable((String)SpiceAndFlavorManager.getFlavorToolTipTranslationKey()).append(":").setStyle(Style.EMPTY.applyFormat(ChatFormatting.WHITE)));
        List<Integer> spiceList = MixedBeerManager.getSpiceList(stack);
        if (!spiceList.isEmpty()) {
            for (int spiceId : spiceList) {
                Flavors flavor = Spices.byId(spiceId).getFlavor();
                tooltip.add((Component)Component.translatable((String)SpiceAndFlavorManager.getFlavorTranslationKey(flavor.getId())).append("(").append((Component)Component.translatable((String)SpiceAndFlavorManager.getFlavorToolTipTranslationKey(flavor.getId()))).append(")").setStyle(Style.EMPTY.applyFormat(ChatFormatting.RED)));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)SpiceAndFlavorManager.getNoFlavorToolTipTranslationKey()).setStyle(Style.EMPTY.applyFormat(ChatFormatting.RED)));
        }
        Flavors combinedFlavor = SpiceAndFlavorManager.getCombinedFlavor(spiceList);
        if (combinedFlavor != null) {
            tooltip.add((Component)Component.literal((String)"\"").append((Component)Component.translatable((String)SpiceAndFlavorManager.getFlavorTranslationKey(combinedFlavor.getId()))).append("\"").setStyle(Style.EMPTY.applyFormat(ChatFormatting.DARK_RED)));
        }
    }

    public Component getName(ItemStack stack) {
        return this.getMixedBeerName(stack);
    }

    public Component getMixedBeerName(ItemStack stack) {
        int beerId = MixedBeerManager.getBeerId(stack);
        Item beerItem = Beers.byId(beerId).getBeerItem();
        String beerName = beerId > 0 ? "block.drinkbeer." + beerItem.toString() : "block.drinkbeer.empty_beer_mug";
        MutableComponent name = Component.translatable((String)beerName).append((Component)Component.translatable((String)("block.drinkbeer." + MixedBeerManager.getMixedBeerTranslationKey()))).setStyle(Style.EMPTY.applyFormat(ChatFormatting.YELLOW));
        return name;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return super.placeBlock(context, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        this.appendMixedBeerTooltip(stack, tooltipComponents);
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        if (context.getClickLocation().distanceTo(context.getPlayer().position()) > 2.0) {
            return false;
        }
        return super.canPlace(context, state);
    }

    public static int getBeerId(ItemStack itemStack) {
        return (Integer)itemStack.get(DataComponentTypeRegistry.BEER_ID_COMPONENT);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        if (!world.isClientSide()) {
            MixedBeerManager.useMixedBeer(stack, world, user);
        }
        this.giveEmptyMugBack(user);
        return super.finishUsingItem(stack, world, user);
    }
}

