/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.compat.jei;

import com.mojang.serialization.Codec;
import lekavar.lma.drinkbeer.recipes.BrewingRecipe;
import lekavar.lma.drinkbeer.registries.ItemRegistry;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class JEIBrewingRecipeCategory
implements IRecipeCategory<BrewingRecipe> {
    public static final RecipeType<BrewingRecipe> TYPE = RecipeType.create((String)"drinkbeer", (String)"brewing", BrewingRecipe.class);
    private static final String DRINK_BEER_YELLOW = "#F4D223";
    private static final String NIGHT_HOWL_CUP_HEX_COLOR = "#C69B82";
    private static final String PUMPKIN_DRINK_CUP_HEX_COLOR = "#AC6132";
    private final IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper guiHelper;

    public JEIBrewingRecipeCategory(IGuiHelper helper) {
        this.guiHelper = helper;
        this.background = helper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"drinkbeer", (String)"textures/gui/jei/brewing_gui.png"), 0, 0, 175, 69);
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)ItemRegistry.BEER_MUG.get()));
    }

    public RecipeType<BrewingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"drinkbeer.jei.title.brewing");
    }

    public int getWidth() {
        return 175;
    }

    public int getHeight() {
        return 69;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BrewingRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 28, 16);
        slotBuilder.addIngredients((Ingredient)ingredients.get(0));
        slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 46, 16);
        slotBuilder.addIngredients((Ingredient)ingredients.get(1));
        slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 28, 34);
        slotBuilder.addIngredients((Ingredient)ingredients.get(2));
        slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 46, 34);
        slotBuilder.addIngredients((Ingredient)ingredients.get(3));
        slotBuilder = builder.addSlot(RecipeIngredientRole.OUTPUT, 128, 24);
        slotBuilder.addItemStack(recipe.getResultItemNoRegistryAccess());
        builder.moveRecipeTransferButton(156, 50);
    }

    public void draw(BrewingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
        IDrawable drawable = this.guiHelper.createDrawableItemStack(recipe.getBeerCup());
        drawable.draw(guiGraphics, 73, 40);
    }

    public void getTooltip(ITooltipBuilder tooltip, BrewingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (!this.inTransferBottomRange(mouseX, mouseY)) {
            if (this.inCupSlotRange(mouseX, mouseY)) {
                tooltip.add((FormattedText)Component.translatable((String)"drinkbeer.jei.tooltip.cup_slot").setStyle(Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)DRINK_BEER_YELLOW).getOrThrow())));
                tooltip.add((FormattedText)Component.translatable((String)"drinkbeer.jei.tooltip.cup_1").setStyle(Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)NIGHT_HOWL_CUP_HEX_COLOR).getOrThrow())).append((Component)Component.literal((String)(recipe.getRequiredCupCount() + " ")).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor((TextColor)TextColor.parseColor((String)DRINK_BEER_YELLOW).getOrThrow()))).append((Component)Component.translatable((String)recipe.getBeerCup().getItem().getDescriptionId()).withStyle(ChatFormatting.WHITE)).append((Component)Component.translatable((String)"drinkbeer.jei.tooltip.cup_2").setStyle(Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)NIGHT_HOWL_CUP_HEX_COLOR).getOrThrow()))));
            } else {
                int brewingTimeMin = recipe.getBrewingTime() / 20 / 60;
                int brewingTimeSec = recipe.getBrewingTime() / 20 - brewingTimeMin * 60;
                tooltip.add((FormattedText)Component.translatable((String)"drinkbeer.jei.tooltip.brewing").setStyle(Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)PUMPKIN_DRINK_CUP_HEX_COLOR).getOrThrow())).append((Component)Component.literal((String)(brewingTimeMin + ":" + String.valueOf(brewingTimeSec < 10 ? "0" + brewingTimeSec : Integer.valueOf(brewingTimeSec)))).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor((TextColor)TextColor.parseColor((String)DRINK_BEER_YELLOW).getOrThrow()))));
            }
        }
    }

    public Codec<BrewingRecipe> getCodec(ICodecHelper codecHelper, IRecipeManager recipeManager) {
        return BrewingRecipe.Serializer.CODEC.codec();
    }

    private boolean inCupSlotRange(double mouseX, double mouseY) {
        return mouseX >= 72.0 && mouseX < 90.0 && mouseY >= 39.0 && mouseY <= 57.0;
    }

    private boolean inTransferBottomRange(double mouseX, double mouseY) {
        return mouseX >= 156.0 && mouseX < 169.0 && mouseY >= 50.0 && mouseY < 63.0;
    }
}

