/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.blocks;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lekavar.lma.drinkbeer.blocks.RecipeBoardBlock;
import lekavar.lma.drinkbeer.registries.SoundEventRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RecipeBoardPackageBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape N_S_SHAPE = Block.box((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)10.0, (double)15.0);
    public static final VoxelShape E_W_SHAPE = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0);

    public RecipeBoardPackageBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.0f).noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    private List<ItemStack> getRecipeBoardDrop() {
        return BuiltInRegistries.BLOCK.entrySet().stream().filter(entry -> {
            Block block = (Block)entry.getValue();
            if (block instanceof RecipeBoardBlock) {
                return ((RecipeBoardBlock)block).isAcquirableViaPackage();
            }
            return false;
        }).map(entry -> ((Block)entry.getValue()).asItem().getDefaultInstance()).collect(Collectors.toList());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!world.isClientSide()) {
            world.playSound(null, pos, SoundEventRegistry.UNPACKING.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
            this.getRecipeBoardDrop().forEach(itemStack -> Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemStack));
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 1);
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    public VoxelShape getShape(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        Direction dir = (Direction)p_220053_1_.getValue((Property)FACING);
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                return N_S_SHAPE;
            }
        }
        return E_W_SHAPE;
    }
}

