/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.blockentities;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lekavar.lma.drinkbeer.gui.BeerBarrelMenu;
import lekavar.lma.drinkbeer.recipes.BrewingRecipe;
import lekavar.lma.drinkbeer.recipes.IBrewingInventory;
import lekavar.lma.drinkbeer.registries.BlockEntityRegistry;
import lekavar.lma.drinkbeer.registries.RecipeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class BeerBarrelBlockEntity
extends BlockEntity
implements MenuProvider {
    private final BrewingInventory brewingInventory = new BrewingInventory(this);
    public final IItemHandler itemHandler = new BarrelInvWrapper(this);
    private int remainingBrewTime;
    private int statusCode;
    public final ContainerData syncData = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> BeerBarrelBlockEntity.this.remainingBrewTime;
                case 1 -> BeerBarrelBlockEntity.this.statusCode;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    BeerBarrelBlockEntity.this.remainingBrewTime = value;
                    break;
                }
                case 1: {
                    BeerBarrelBlockEntity.this.statusCode = value;
                }
            }
        }

        public int getCount() {
            return 1;
        }
    };

    public BeerBarrelBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.BEER_BARREL_TILEENTITY.get(), pos, state);
    }

    public void tickServer() {
        if (this.statusCode == 0) {
            if (this.brewingInventory.getIngredients().size() == 4) {
                RecipeHolder recipeholder = this.level.getRecipeManager().getRecipeFor(RecipeRegistry.RECIPE_TYPE_BREWING.get(), (RecipeInput)this.brewingInventory, this.level).orElse(null);
                BrewingRecipe recipe = (BrewingRecipe)recipeholder.value();
                if (this.canBrew(recipe)) {
                    this.setResult(recipe);
                    if (this.hasEnoughEmptyCap(recipe)) {
                        this.startBrewing(recipe);
                    }
                } else {
                    this.clearResult();
                }
            } else {
                this.clearResult();
            }
        } else if (this.statusCode == 1) {
            if (this.remainingBrewTime > 0) {
                --this.remainingBrewTime;
            } else {
                this.remainingBrewTime = 0;
                this.statusCode = 2;
            }
            this.setChanged();
        } else if (this.statusCode == 2) {
            if (this.brewingInventory.getItem(5).isEmpty()) {
                this.statusCode = 0;
                this.setChanged();
            }
        } else {
            this.remainingBrewTime = 0;
            this.statusCode = 0;
            this.setChanged();
        }
    }

    private boolean canBrew(@Nullable BrewingRecipe recipe) {
        if (recipe != null) {
            return recipe.matches(this.brewingInventory, this.level);
        }
        return false;
    }

    private boolean hasEnoughEmptyCap(BrewingRecipe recipe) {
        return recipe.isCupQualified(this.brewingInventory);
    }

    private void startBrewing(BrewingRecipe recipe) {
        for (int i = 0; i < 4; ++i) {
            ItemStack ingred = this.brewingInventory.getItem(i);
            if (this.shouldReturnBucket(ingred)) {
                this.brewingInventory.setItem(i, Items.BUCKET.getDefaultInstance());
                continue;
            }
            ingred.shrink(1);
        }
        this.brewingInventory.getItem(4).shrink(recipe.getRequiredCupCount());
        this.remainingBrewTime = recipe.getBrewingTime();
        this.statusCode = 1;
        this.markDirty();
    }

    private boolean shouldReturnBucket(ItemStack item) {
        return item.getItem() instanceof BucketItem || item.getItem() instanceof MilkBucketItem;
    }

    private void clearResult() {
        if (!this.brewingInventory.getItem(5).isEmpty()) {
            this.brewingInventory.setItem(5, ItemStack.EMPTY);
            this.remainingBrewTime = 0;
            this.markDirty();
        }
    }

    private void setResult(BrewingRecipe recipe) {
        ItemStack result = recipe.assemble(this.brewingInventory, (HolderLookup.Provider)this.level.registryAccess());
        if (!ItemStack.matches((ItemStack)result, (ItemStack)this.brewingInventory.getItem(5))) {
            this.brewingInventory.setItem(5, recipe.assemble(this.brewingInventory, (HolderLookup.Provider)this.level.registryAccess()));
            this.remainingBrewTime = recipe.getBrewingTime();
            this.markDirty();
        }
    }

    public BrewingInventory getBrewingInventory() {
        return this.brewingInventory;
    }

    public void markDirty() {
        BlockPos pos = this.getBlockPos();
        BlockState bs = this.level.getBlockState(pos);
        this.level.sendBlockUpdated(pos, bs, bs, 2);
        this.setChanged();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inv", (Tag)this.brewingInventory.createTag(registries));
        tag.putShort("RemainingBrewTime", (short)this.remainingBrewTime);
        tag.putShort("statusCode", (short)this.statusCode);
    }

    public void loadAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.remainingBrewTime = tag.getShort("RemainingBrewTime");
        this.statusCode = tag.getShort("statusCode");
        this.brewingInventory.fromTag((ListTag)tag.get("inv"), registries);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.drinkbeer.beer_barrel");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new BeerBarrelMenu(id, (Container)this.brewingInventory, this.syncData, inventory, this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        this.handleUpdateTag(pkt.getTag(), registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.put("inv", (Tag)this.brewingInventory.createTag(registries));
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.brewingInventory.fromTag((ListTag)tag.get("inv"), registries);
    }

    public static class BrewingInventory
    extends SimpleContainer
    implements IBrewingInventory {
        BeerBarrelBlockEntity be;

        public BrewingInventory(BeerBarrelBlockEntity be) {
            super(6);
            this.be = be;
        }

        @Override
        @NotNull
        public List<ItemStack> getIngredients() {
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            if (this.isEmpty()) {
                return ret;
            }
            for (int i = 0; i < 4; ++i) {
                if (this.getItem(i).isEmpty()) continue;
                ret.add(this.getItem(i));
            }
            return ret;
        }

        @Override
        @NotNull
        public ItemStack getCup() {
            return this.getItem(4);
        }

        public boolean canPlaceItem(int pIndex, ItemStack pStack) {
            return super.canPlaceItem(pIndex, pStack);
        }

        public boolean stillValid(Player pPlayer) {
            if (this.be.level.getBlockEntity(this.be.worldPosition) != this.be) {
                return false;
            }
            return !(pPlayer.distanceToSqr((double)this.be.worldPosition.getX() + 0.5, (double)this.be.worldPosition.getY() + 0.5, (double)this.be.worldPosition.getZ() + 0.5) > 64.0);
        }

        public int size() {
            return 6;
        }
    }

    static class BarrelInvWrapper
    extends ItemStackHandler {
        private BrewingInventory brewingInventory;
        private BeerBarrelBlockEntity be;

        public BarrelInvWrapper(BeerBarrelBlockEntity be) {
            this.brewingInventory = be.brewingInventory;
            this.be = be;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            this.brewingInventory.setItem(5, stack);
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (this.be.statusCode != 2) {
                return ItemStack.EMPTY;
            }
            return this.brewingInventory.getItem(5);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.be.statusCode != 2) {
                return ItemStack.EMPTY;
            }
            ItemStack ret = this.brewingInventory.getItem(5).copy();
            amount = Math.min(ret.getCount(), amount);
            ret.setCount(amount);
            if (!simulate) {
                this.brewingInventory.getItem(5).shrink(amount);
            }
            return ret;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }
}

