/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.panel;

import com.ldtteam.domumornamentum.block.AbstractPanelBlockTrapdoor;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.types.TrapdoorType;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import com.ldtteam.domumornamentum.util.Constants;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PanelBlockStateProvider
extends BlockStateProvider {
    public PanelBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)ModBlocks.getInstance().getPanel());
        for (Direction facingValue : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
            for (TrapdoorType typeValue : TrapdoorBlock.TYPE.getPossibleValues()) {
                for (Half halfValue : AbstractPanelBlockTrapdoor.HALF.getPossibleValues()) {
                    Iterator iterator = AbstractPanelBlockTrapdoor.OPEN.getPossibleValues().iterator();
                    while (iterator.hasNext()) {
                        boolean openValue = (Boolean)iterator.next();
                        ConfiguredModel.Builder partBuilder = builder.part();
                        ((MultiPartBlockStateBuilder.PartBuilder)partBuilder.modelFile((ModelFile)((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/panel/panel_" + typeValue.getSerializedName(), this.modLoc("block/panel/panel_%s_spec".formatted(typeValue.getSerializedName())))).customLoader(MateriallyTexturedModelBuilder::new)).end()).uvLock(true).rotationY(this.getYFromFacing(facingValue) + this.getYFromOpenAndHalf(openValue, halfValue)).rotationX(this.getXFromOpenAndHalf(openValue, halfValue)).addModel()).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{facingValue}).condition(TrapdoorBlock.TYPE, (Comparable[])new TrapdoorType[]{typeValue}).condition(AbstractPanelBlockTrapdoor.HALF, (Comparable[])new Half[]{halfValue}).condition((Property)AbstractPanelBlockTrapdoor.OPEN, (Comparable[])new Boolean[]{openValue}).end();
                    }
                }
            }
        }
        ItemModelBuilder itemSpecModelBuilder = (ItemModelBuilder)this.itemModels().withExistingParent("panel_spec", this.mcLoc("block/thin_block"));
        TrapdoorType[] values = TrapdoorType.values();
        for (int i = 0; i < values.length; ++i) {
            TrapdoorType value = values[i];
            ItemModelBuilder.OverrideBuilder overrideBuilder = itemSpecModelBuilder.override();
            overrideBuilder.predicate(Constants.TRAPDOOR_MODEL_OVERRIDE, (float)i);
            overrideBuilder.model((ModelFile)this.itemModels().getExistingFile(this.modLoc("block/panel/panel_%s_spec".formatted(value.getSerializedName()))));
            overrideBuilder.end();
        }
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)((MateriallyTexturedModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(ModBlocks.getInstance().getPanel().getRegistryName().getPath())).parent((ModelFile)itemSpecModelBuilder)).customLoader(MateriallyTexturedModelBuilder::new)).end();
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilder);
    }

    @Contract(pure=true)
    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 0;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            case Direction.EAST -> 90;
        };
    }

    private int getYFromOpenAndHalf(boolean open, Half half) {
        if (!open) {
            return half == Half.TOP ? 0 : 180;
        }
        return half == Half.TOP ? 180 : 0;
    }

    private int getXFromOpenAndHalf(boolean open, Half half) {
        if (!open) {
            return half == Half.TOP ? 180 : 0;
        }
        return half == Half.TOP ? -90 : 90;
    }

    @NotNull
    public String getName() {
        return "Panel BlockStates Provider";
    }
}

