/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.container;

import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IModBlocks;
import com.ldtteam.domumornamentum.block.MateriallyTexturedBlockManager;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.container.ModContainerTypes;
import com.ldtteam.domumornamentum.recipe.ModRecipeTypes;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipe;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipeInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ArchitectsCutterContainer
extends AbstractContainerMenu {
    private final ContainerLevelAccess worldPosCallable;
    private final Level world;
    private List<RecipeHolder<ArchitectsCutterRecipe>> recipes = Lists.newArrayList();
    private final NonNullList<ItemStack> inputItemStacks = NonNullList.withSize((int)MateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount(), (Object)ItemStack.EMPTY);
    private long lastOnTake;
    final List<Slot> inputInventorySlots = Lists.newArrayList();
    public final Slot outputInventorySlot;
    private Runnable inventoryUpdateListener = () -> {};
    public final Container inputInventory = new SimpleContainer(MateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount()){

        public void setChanged() {
            super.setChanged();
            ArchitectsCutterContainer.this.slotsChanged((Container)this);
            ArchitectsCutterContainer.this.inventoryUpdateListener.run();
        }
    };
    private final ResultContainer inventory = new ResultContainer();
    private ResourceLocation currentGroup;
    private ItemStack currentVariant;

    public ArchitectsCutterContainer(int windowIdIn, Inventory playerInventoryIn) {
        this(windowIdIn, playerInventoryIn, ContainerLevelAccess.NULL);
    }

    public ArchitectsCutterContainer(int windowIdIn, Inventory playerInventoryIn, final ContainerLevelAccess worldPosCallableIn) {
        super((MenuType)ModContainerTypes.ARCHITECTS_CUTTER.get(), windowIdIn);
        int i;
        this.worldPosCallable = worldPosCallableIn;
        this.world = playerInventoryIn.player.level();
        for (i = 0; i < MateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount(); ++i) {
            int x = 96;
            int y = 66 + i * 20;
            this.inputInventorySlots.add(this.addSlot(new Slot(this.inputInventory, i, x, y){

                public boolean mayPlace(@NotNull ItemStack stack) {
                    if (ArchitectsCutterContainer.this.currentVariant == null) {
                        return MateriallyTexturedBlockManager.getInstance().doesItemStackContainsMaterialForSlot(this.getSlotIndex(), stack);
                    }
                    return MateriallyTexturedBlockManager.getInstance().doesItemStackContainsMaterialForSlot(this.getSlotIndex(), stack, ArchitectsCutterContainer.this.currentVariant);
                }
            }));
        }
        this.outputInventorySlot = this.addSlot(new Slot((Container)this.inventory, 1, 183, 77){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }

            public void onTake(@NotNull Player thePlayer, @NotNull ItemStack stack) {
                BlockItem blockItem;
                stack.onCraftedBy(thePlayer.level(), thePlayer, stack.getCount());
                boolean anyEmpty = false;
                List<Slot> inventorySlots = ArchitectsCutterContainer.this.inputInventorySlots;
                ArchitectsCutterContainer.this.inventory.awardUsedRecipes(thePlayer, inventorySlots.stream().map(slot -> slot.getItem()).collect(Collectors.toList()));
                Item item = stack.getItem();
                boolean craftingMateriallyTexturedBlock = item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof IMateriallyTexturedBlock;
                ArrayList components = craftingMateriallyTexturedBlock ? Lists.newArrayList(((IMateriallyTexturedBlock)((BlockItem)stack.getItem()).getBlock()).getComponents()) : Collections.emptyList();
                int componentSize = craftingMateriallyTexturedBlock ? components.size() : 1;
                for (int i = 0; i < inventorySlots.size(); ++i) {
                    boolean isRequiredBlock;
                    Slot inputInventorySlot = inventorySlots.get(i);
                    boolean bl = isRequiredBlock = i < componentSize;
                    if (inputInventorySlot.getItem().isEmpty() || !isRequiredBlock || thePlayer.isCreative() || !inputInventorySlot.remove(1).isEmpty()) continue;
                    anyEmpty = true;
                }
                if (!anyEmpty) {
                    ArchitectsCutterContainer.this.updateRecipeResultSlot();
                }
                worldPosCallableIn.execute((world, pos) -> {
                    long gameTime = world.getGameTime();
                    if (ArchitectsCutterContainer.this.lastOnTake != gameTime) {
                        world.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        ArchitectsCutterContainer.this.lastOnTake = gameTime;
                    }
                });
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventoryIn, j + i * 9 + 9, 40 + j * 18, 120 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventoryIn, k, 40 + k * 18, 178));
        }
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return ArchitectsCutterContainer.stillValid((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)IModBlocks.getInstance().getArchitectsCutter());
    }

    public boolean clickMenuButton(@NotNull Player playerIn, int id) {
        if (id < ModBlocks.getInstance().getOrComputeItemGroups().size()) {
            this.selectGroup(new ArrayList<ResourceLocation>(ModBlocks.getInstance().getOrComputeItemGroups().keySet()).get(id));
            this.outputInventorySlot.set(ItemStack.EMPTY);
            this.broadcastChanges();
            return true;
        }
        int dif = id - ModBlocks.getInstance().getOrComputeItemGroups().size();
        if (dif < ModBlocks.getInstance().getOrComputeItemGroups().get(this.getCurrentGroup()).size()) {
            this.selectVariant(ModBlocks.getInstance().getOrComputeItemGroups().get(this.getCurrentGroup()).get(dif));
            this.updateRecipeResultSlot();
            return true;
        }
        return true;
    }

    public void slotsChanged(@NotNull Container inventoryIn) {
        boolean anyChanged = false;
        List<Slot> slots = this.inputInventorySlots;
        for (int i = 0; i < slots.size(); ++i) {
            Slot inputInventorySlot = slots.get(i);
            ItemStack inputStack = (ItemStack)this.inputItemStacks.get(i);
            if (inputInventorySlot.getItem().getItem() == inputStack.getItem()) continue;
            anyChanged = true;
        }
        if (anyChanged) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < slots.size(); ++i) {
                ItemStack itemStack = this.inputInventorySlots.get(i).getItem();
                stacks.add(itemStack);
                this.inputItemStacks.set(i, (Object)itemStack.copy());
            }
            this.updateAvailableRecipes(inventoryIn, stacks);
        }
    }

    private void updateAvailableRecipes(Container inventoryIn, List<ItemStack> stacks) {
        this.recipes.clear();
        this.outputInventorySlot.set(ItemStack.EMPTY);
        if (!stacks.stream().allMatch(ItemStack::isEmpty)) {
            this.recipes = this.world.getRecipeManager().getRecipesFor((RecipeType)ModRecipeTypes.ARCHITECTS_CUTTER.get(), (RecipeInput)new ArchitectsCutterRecipeInput(inventoryIn), this.world);
            this.recipes.sort(Comparator.comparing(h -> ((ArchitectsCutterRecipe)h.value()).getBlockName()).thenComparing(RecipeHolder::id));
        }
        this.updateRecipeResultSlot();
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty() && this.currentVariant != null && this.currentVariant.getItem() instanceof BlockItem) {
            for (RecipeHolder<ArchitectsCutterRecipe> recipeHolder : this.recipes) {
                ArchitectsCutterRecipe recipe = (ArchitectsCutterRecipe)recipeHolder.value();
                ItemStack resultItem = recipe.getResultItem((HolderLookup.Provider)this.world.registryAccess());
                if (resultItem.getItem() != this.currentVariant.getItem()) continue;
                BlockItemStateProperties resultBlockState = (BlockItemStateProperties)resultItem.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY);
                BlockItemStateProperties currentBlockState = (BlockItemStateProperties)this.currentVariant.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY);
                if ((!resultBlockState.isEmpty() || !currentBlockState.isEmpty()) && !resultBlockState.equals((Object)currentBlockState)) continue;
                this.inventory.setRecipeUsed(recipeHolder);
                this.outputInventorySlot.set(recipe.assemble(new ArchitectsCutterRecipeInput(this.inputInventory), (HolderLookup.Provider)this.world.registryAccess()));
                break;
            }
        } else {
            this.outputInventorySlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    @NotNull
    public MenuType<?> getType() {
        return (MenuType)ModContainerTypes.ARCHITECTS_CUTTER.get();
    }

    public boolean canTakeItemForPickAll(@NotNull ItemStack stack, Slot slotIn) {
        return slotIn.container != this.inventory && super.canTakeItemForPickAll(stack, slotIn);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int clickedSlot) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(clickedSlot);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (clickedSlot == 2) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
                slot.onTake(player, itemstack);
                return itemstack;
            }
            if (clickedSlot > 2) {
                if (!this.moveItemStackTo(itemstack1, 0, 2, false)) {
                    return ItemStack.EMPTY;
                }
                if (clickedSlot < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : clickedSlot < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public void removed(@NotNull Player playerIn) {
        super.removed(playerIn);
        this.inventory.removeItemNoUpdate(1);
        this.worldPosCallable.execute((p_217079_2_, p_217079_3_) -> this.clearContainer(playerIn, this.inputInventory));
    }

    public ResourceLocation getCurrentGroup() {
        return this.currentGroup;
    }

    public ItemStack getCurrentVariant() {
        return this.currentVariant;
    }

    public void selectVariant(ItemStack itemStack) {
        this.currentVariant = itemStack;
    }

    public void selectGroup(ResourceLocation location) {
        this.currentGroup = location;
    }
}

