/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yablon.deco_storage.recipe.StorageExtractorRecipe;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class StorageExtractorRecipeSerializer
implements RecipeSerializer<StorageExtractorRecipe> {
    public static final MapCodec<StorageExtractorRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.listOf().xmap(NonNullList::copyOf, Function.identity()).fieldOf("ingredients").forGetter(StorageExtractorRecipe::getIngredients), (App)ItemStack.CODEC.fieldOf("first_output").forGetter(StorageExtractorRecipe::getFirstOutput), (App)ItemStack.CODEC.fieldOf("second_output").forGetter(StorageExtractorRecipe::getSecondOutput), (App)Codec.FLOAT.fieldOf("bonus_chance").forGetter(StorageExtractorRecipe::getBonusChance)).apply((Applicative)instance, (ingredients, firstOutput, secondOutput, bonusChance) -> new StorageExtractorRecipe((NonNullList<Ingredient>)ingredients, (ItemStack)firstOutput, (ItemStack)secondOutput, bonusChance.floatValue())));
    private static final StreamCodec<RegistryFriendlyByteBuf, Float> FLOAT_STREAM_CODEC = StreamCodec.of((buffer, value) -> buffer.writeFloat(value.floatValue()), FriendlyByteBuf::readFloat);
    public static final StreamCodec<RegistryFriendlyByteBuf, StorageExtractorRecipe> STREAM_CODEC = StreamCodec.composite(StorageExtractorRecipeSerializer.createNonNullListStreamCodec(Ingredient.CONTENTS_STREAM_CODEC), StorageExtractorRecipe::getIngredients, (StreamCodec)ItemStack.STREAM_CODEC, StorageExtractorRecipe::getFirstOutput, (StreamCodec)ItemStack.STREAM_CODEC, StorageExtractorRecipe::getSecondOutput, FLOAT_STREAM_CODEC, StorageExtractorRecipe::getBonusChance, StorageExtractorRecipe::new);

    private static <T> StreamCodec<RegistryFriendlyByteBuf, NonNullList<T>> createNonNullListStreamCodec(StreamCodec<RegistryFriendlyByteBuf, T> elementCodec) {
        return StreamCodec.of((buffer, list) -> {
            buffer.writeVarInt(list.size());
            for (Object element : list) {
                elementCodec.encode(buffer, element);
            }
        }, buffer -> {
            int size = buffer.readVarInt();
            NonNullList list = NonNullList.create();
            for (int i = 0; i < size; ++i) {
                list.add(elementCodec.decode(buffer));
            }
            return list;
        });
    }

    public MapCodec<StorageExtractorRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, StorageExtractorRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

