/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage.integration.jei;

import com.yablon.deco_storage.block.ModBlocks;
import com.yablon.deco_storage.recipe.StorageExtractorRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class StorageExtractorRecipeCategory
implements IRecipeCategory<StorageExtractorRecipe> {
    public static final ResourceLocation UID = ResourceLocation.parse((String)"deco_storage:storage_extractor");
    public static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"deco_storage:textures/gui/storage_extractor.png");
    public static final RecipeType<StorageExtractorRecipe> STORAGE_EXTRACTOR_RECIPE_TYPE = new RecipeType(UID, StorageExtractorRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public StorageExtractorRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 80);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.STORAGE_EXTRACTOR.get()));
    }

    public RecipeType<StorageExtractorRecipe> getRecipeType() {
        return STORAGE_EXTRACTOR_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"gui.deco_storage.storage_extractor");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StorageExtractorRecipe recipe, IFocusGroup focuses) {
        if (recipe.getIngredients().isEmpty()) {
            return;
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 80, 11).addIngredients((Ingredient)recipe.getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 59).addItemStack(recipe.getFirstOutput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 101, 59).addItemStack(recipe.getSecondOutput());
        float bonusChance = recipe.getBonusChance();
        if (bonusChance > 0.0f) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 101, 59).addTooltipCallback((view, tooltip) -> tooltip.add(Component.literal((String)("Chance: " + (int)(bonusChance * 100.0f) + "%"))));
        }
    }
}

