/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.recipe.liquid_burning;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrh0.createaddition.index.CARecipes;
import com.mrh0.createaddition.recipe.FluidRecipeWrapper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class LiquidBurningRecipe
implements Recipe<FluidRecipeWrapper> {
    protected FluidIngredient fluidIngredients;
    protected int burnTime;
    protected boolean superheated;

    public LiquidBurningRecipe(String group, FluidIngredient fluid, int burnTime, boolean superheated) {
        this.fluidIngredients = fluid;
        this.burnTime = burnTime;
        this.superheated = superheated;
    }

    public boolean matches(@NotNull FluidRecipeWrapper wrapper, @NotNull Level world) {
        if (this.fluidIngredients == null) {
            return false;
        }
        if (wrapper.fluid == null) {
            return false;
        }
        return this.fluidIngredients.test(wrapper.fluid);
    }

    @NotNull
    public ItemStack assemble(@NotNull FluidRecipeWrapper fluidRecipeWrapper, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return new ItemStack((ItemLike)Items.AIR);
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return new ItemStack((ItemLike)Items.AIR);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)CARecipes.LIQUID_BURNING.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return CARecipes.LIQUID_BURNING_TYPE.get();
    }

    public FluidIngredient getFluidIngredient() {
        return this.fluidIngredients;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public boolean isSuperheated() {
        return this.superheated;
    }

    public static class Serializer
    implements RecipeSerializer<LiquidBurningRecipe> {
        private static final MapCodec<LiquidBurningRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(Recipe::getGroup), (App)FluidIngredient.CODEC.fieldOf("input").forGetter(r -> r.fluidIngredients), (App)Codec.INT.optionalFieldOf("burnTime", (Object)0).forGetter(r -> r.burnTime), (App)Codec.BOOL.optionalFieldOf("superheated", (Object)false).forGetter(r -> r.superheated)).apply((Applicative)builder, LiquidBurningRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, LiquidBurningRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<LiquidBurningRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, LiquidBurningRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static LiquidBurningRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            boolean superheated = buffer.readBoolean();
            int burnTime = buffer.readInt();
            FluidIngredient input = (FluidIngredient)FluidIngredient.STREAM_CODEC.decode((Object)buffer);
            return new LiquidBurningRecipe(group, input, burnTime, superheated);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, LiquidBurningRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeBoolean(recipe.superheated);
            buffer.writeInt(recipe.burnTime);
            FluidIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluidIngredients);
        }
    }
}

