/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.datagen.RecipeProvider;

import com.mrh0.createaddition.datagen.RecipeBuilders.CALiquidBurningRecipeBuilder;
import com.mrh0.createaddition.datagen.TagProvider.CATagRegister;
import com.mrh0.createaddition.index.CARecipes;
import com.mrh0.createaddition.recipe.conditions.HasFluidTagCondition;
import com.simibubi.create.foundation.data.recipe.ProcessingRecipeGen;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class CALiquidBurningRecipeProvider
extends ProcessingRecipeGen {
    public static final IRecipeTypeInfo recipeType = new IRecipeTypeInfo(){

        public ResourceLocation getId() {
            return CARecipes.LIQUID_BURNING.getId();
        }

        public <T extends RecipeSerializer<?>> T getSerializer() {
            return (T)((RecipeSerializer)CARecipes.LIQUID_BURNING.get());
        }

        public <V extends RecipeInput, R extends Recipe<V>> RecipeType<R> getType() {
            return CARecipes.LIQUID_BURNING_TYPE.get();
        }
    };
    private final HolderLookup.Provider provider;

    public CALiquidBurningRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
        try {
            this.provider = registries.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected void buildRecipes(@NotNull RecipeOutput output) {
        CALiquidBurningRecipeBuilder.liquidBurning(24000).require(CATagRegister.Fluids.BIOFUEL).superheated().save(output, "biofuel");
        CALiquidBurningRecipeBuilder.liquidBurning(4800).require(CATagRegister.Fluids.PLANTOIL).save(output, "plantoil");
        CALiquidBurningRecipeBuilder.liquidBurning(20000).require((TagKey<Fluid>)FluidTags.LAVA).save(output, "lava");
        CALiquidBurningRecipeBuilder.liquidBurning(24000).require(CATagRegister.Fluids.BIODIESEL).save(output.withConditions(new ICondition[]{new HasFluidTagCondition(CATagRegister.Fluids.BIODIESEL)}), "biodiesel");
        CALiquidBurningRecipeBuilder.liquidBurning(4800).require(CATagRegister.Fluids.CREOSOTE).save(output.withConditions(new ICondition[]{new HasFluidTagCondition(CATagRegister.Fluids.CREOSOTE)}), "creosote");
        CALiquidBurningRecipeBuilder.liquidBurning(9600).require(CATagRegister.Fluids.CRUDE_OIL).save(output.withConditions(new ICondition[]{new HasFluidTagCondition(CATagRegister.Fluids.CRUDE_OIL)}), "crude_oil");
        CALiquidBurningRecipeBuilder.liquidBurning(24000).require(CATagRegister.Fluids.DIESEL).save(output.withConditions(new ICondition[]{new HasFluidTagCondition(CATagRegister.Fluids.DIESEL)}), "diesel");
        CALiquidBurningRecipeBuilder.liquidBurning(8000).require(CATagRegister.Fluids.ETHANOL).save(output.withConditions(new ICondition[]{new HasFluidTagCondition(CATagRegister.Fluids.ETHANOL)}), "ethanol");
        CALiquidBurningRecipeBuilder.liquidBurning(24000).require(CATagRegister.Fluids.GASOLINE).save(output.withConditions(new ICondition[]{new HasFluidTagCondition(CATagRegister.Fluids.GASOLINE)}), "gasoline");
    }

    protected IRecipeTypeInfo getRecipeType() {
        return recipeType;
    }
}

