/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.datagen.RecipeBuilders;

import com.mrh0.createaddition.datagen.RecipeBuilders.CARecipeBuilder;
import com.mrh0.createaddition.recipe.rolling.RollingRecipe;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;

public class CARollingRecipeBuilder
extends CARecipeBuilder {
    protected Ingredient ingredient = Ingredient.EMPTY;

    public CARollingRecipeBuilder(ItemStack result) {
        super(result);
    }

    public static CARollingRecipeBuilder rolling(ItemStack itemStack) {
        return new CARollingRecipeBuilder(itemStack);
    }

    public static CARollingRecipeBuilder rolling(ItemLike result, int count) {
        return CARollingRecipeBuilder.rolling(new ItemStack(result, count));
    }

    public static CARollingRecipeBuilder rolling(ItemLike result) {
        return CARollingRecipeBuilder.rolling(new ItemStack(result));
    }

    public static CARollingRecipeBuilder rolling(Item result, int count) {
        return CARollingRecipeBuilder.rolling(new ItemStack((ItemLike)result, count));
    }

    public static CARollingRecipeBuilder rolling(Item result) {
        return CARollingRecipeBuilder.rolling(new ItemStack((ItemLike)result));
    }

    public static CARollingRecipeBuilder rolling(ItemStack item, ResourceKey<Enchantment> enchantmentKey, HolderLookup.Provider provider) {
        item.enchant(provider.holderOrThrow(enchantmentKey), 1);
        return CARollingRecipeBuilder.rolling(item);
    }

    public CARollingRecipeBuilder require(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public CARollingRecipeBuilder require(TagKey<Item> tag) {
        this.require(Ingredient.of(tag));
        return this;
    }

    public CARollingRecipeBuilder require(ItemLike item) {
        this.require(Ingredient.of((ItemLike[])new ItemLike[]{item}));
        return this;
    }

    public CARollingRecipeBuilder require(ItemStack item) {
        this.require(Ingredient.of((ItemStack[])new ItemStack[]{item}));
        return this;
    }

    public CARollingRecipeBuilder require(ItemLike item, int count) {
        for (int i = 0; i < count; ++i) {
            this.require(Ingredient.of((ItemLike[])new ItemLike[]{item}));
        }
        return this;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        RollingRecipe rollingRecipe = new RollingRecipe(Objects.requireNonNullElse(this.group, ""), this.ingredient, this.result);
        recipeOutput.accept(resourceLocation.withPrefix("rolling/"), (Recipe)rollingRecipe, null);
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, BuiltInRegistries.ITEM.getKey((Object)this.result.getItem()).getPath());
    }

    public void save(RecipeOutput recipeOutput, String id) {
        this.save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)id));
    }
}

